/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.gzip.zipnum;

import java.io.IOException;
import java.util.logging.Logger;
import org.archive.util.iterator.AbstractPeekableIterator;
import org.archive.util.iterator.CloseableIterator;

public class MultiBlockIterator
extends AbstractPeekableIterator<String> {
    private static final Logger LOGGER = Logger.getLogger(MultiBlockIterator.class.getName());
    private CloseableIterator<String> currLoader = null;
    private CloseableIterator<CloseableIterator<String>> blockItr = null;

    public MultiBlockIterator(CloseableIterator<CloseableIterator<String>> blockItr) {
        this.blockItr = blockItr;
    }

    @Override
    public String getNextInner() {
        while (true) {
            if (this.currLoader == null) {
                if (this.blockItr.hasNext()) {
                    this.currLoader = (CloseableIterator)this.blockItr.next();
                } else {
                    return null;
                }
            }
            if (this.currLoader.hasNext()) {
                String next = (String)this.currLoader.next();
                return next;
            }
            try {
                this.currLoader.close();
            }
            catch (IOException exc) {
                LOGGER.warning(exc.toString());
            }
            this.currLoader = null;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.currLoader != null) {
            try {
                this.currLoader.close();
            }
            catch (IOException exc) {
                LOGGER.warning(exc.toString());
            }
            this.currLoader = null;
        }
        if (this.blockItr != null) {
            this.blockItr.close();
            this.blockItr = null;
        }
    }
}

