/*
 * Decompiled with CFR 0.152.
 */
package org.archive.hadoop.func;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.archive.format.json.JSONUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONViewEvalFunc
extends EvalFunc<Tuple> {
    private static final Logger LOG = Logger.getLogger(JSONViewEvalFunc.class.getName());
    protected TupleFactory mTupleFactory = TupleFactory.getInstance();
    private ArrayList<Object> mProtoTuple = new ArrayList();

    public Tuple exec(Tuple tup) throws IOException {
        if (tup == null || tup.size() == 0) {
            return null;
        }
        try {
            JSONObject json = new JSONObject(tup.get(0).toString());
            for (int i = 1; i < tup.size(); ++i) {
                String path = tup.get(i).toString();
                String result = JSONUtils.extractSingle(json, path);
                this.mProtoTuple.add(result);
            }
        }
        catch (JSONException e) {
            LOG.warning("Failed to parse JSON:" + e.getMessage());
            return null;
        }
        Tuple t = this.mTupleFactory.newTuple(this.mProtoTuple);
        this.mProtoTuple.clear();
        return t;
    }
}

