/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.DataInput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteOp {
    private static int MAX_READ_SIZE = 131072;

    public static byte[] copy(byte[] src) {
        return ByteOp.copy(src, 0, src.length);
    }

    public static byte[] copy(byte[] src, int offset, int length) {
        byte[] copy = new byte[length];
        System.arraycopy(src, offset, copy, 0, length);
        return copy;
    }

    public static boolean cmp(byte[] input, byte[] want) {
        if (input.length != want.length) {
            return false;
        }
        for (int i = 0; i < input.length; ++i) {
            if (input[i] == want[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean cmp(byte[] b1, int src1, byte[] b2, int src2, int n) {
        if (b1.length < src1 + n) {
            throw new IndexOutOfBoundsException();
        }
        if (b2.length < src2 + n) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n; ++i) {
            if (b1[src1 + i] == b2[src2 + i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] append(byte[] a, byte[] b) {
        byte[] n = new byte[a.length + b.length];
        System.arraycopy(a, 0, n, 0, a.length);
        System.arraycopy(b, 0, n, a.length, b.length);
        return n;
    }

    public static int bytesToShort(int b1, int b2) {
        return b2 << 8 & 0xFF00 | b1 & 0xFF;
    }

    public static int bytesToShort(byte[] bytes, int offset) {
        if (bytes.length - offset < 2) {
            throw new IndexOutOfBoundsException();
        }
        return ByteOp.bytesToShort(bytes[offset], (int)bytes[offset + 1]);
    }

    public static int bytesToShort(byte[] bytes) {
        return ByteOp.bytesToShort(bytes, 0);
    }

    public static int readShort(DataInput in) throws IOException {
        return ByteOp.bytesToShort(in.readByte(), (int)in.readByte());
    }

    public static int readShort(InputStream is) throws IOException {
        int b1 = is.read();
        if (b1 == -1) {
            throw new EOFException("No bytes expected short(2)");
        }
        int b2 = is.read();
        if (b2 == -1) {
            throw new EOFException("One byte expected short(2)");
        }
        return ByteOp.bytesToShort(b1, b2);
    }

    public static void writeShort(OutputStream os, int shortVal) throws IOException {
        os.write((byte)(shortVal & 0xFF));
        os.write((byte)((shortVal & 0xFF00) >> 8 & 0xFF));
    }

    public static void writeShort(byte[] buf, int offset, int shortVal) {
        if (buf.length - offset < 2) {
            throw new IndexOutOfBoundsException();
        }
        buf[offset + 0] = (byte)(shortVal & 0xFF);
        buf[offset + 1] = (byte)((shortVal & 0xFF00) >> 8 & 0xFF);
    }

    public static long bytesToInt(int b1, int b2, int b3, int b4) {
        long res = b1 & 0xFF | b2 << 8 & 0xFF00 | b3 << 16 & 0xFF0000 | b4 << 24 & 0xFF000000;
        return res;
    }

    public static long bytesToInt(byte[] bytes, int offset) {
        if (bytes.length - offset < 4) {
            throw new IndexOutOfBoundsException();
        }
        return ByteOp.bytesToInt(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3]);
    }

    public static long bytesToInt(byte[] bytes) {
        return ByteOp.bytesToInt(bytes, 0);
    }

    public static long readInt(DataInput in) throws IOException {
        return ByteOp.bytesToInt(in.readByte(), in.readByte(), in.readByte(), in.readByte());
    }

    public static long readInt(InputStream is) throws IOException {
        int b1 = is.read();
        if (b1 == -1) {
            throw new EOFException("No bytes for Int(4)");
        }
        int b2 = is.read();
        if (b2 == -1) {
            throw new EOFException("Only 1 bytes for Int(4)");
        }
        int b3 = is.read();
        if (b3 == -1) {
            throw new EOFException("Only 2 bytes for Int(4)");
        }
        int b4 = is.read();
        if (b4 == -1) {
            throw new EOFException("Only 3 bytes for Int(4)");
        }
        return ByteOp.bytesToInt(b1, b2, b3, b4);
    }

    public static void writeInt(OutputStream os, long intVal) throws IOException {
        os.write((byte)(intVal & 0xFFL));
        os.write((byte)((intVal & 0xFF00L) >> 8 & 0xFFL));
        os.write((byte)((intVal & 0xFF0000L) >> 16 & 0xFFL));
        os.write((byte)((intVal & 0xFFFFFFFFFF000000L) >> 24 & 0xFFL));
    }

    public static void writeInt(byte[] buf, int offset, long intVal) {
        if (buf.length - offset < 4) {
            throw new IndexOutOfBoundsException();
        }
        buf[offset + 0] = (byte)(intVal & 0xFFL);
        buf[offset + 1] = (byte)((intVal & 0xFF00L) >> 8 & 0xFFL);
        buf[offset + 2] = (byte)((intVal & 0xFF0000L) >> 16 & 0xFFL);
        buf[offset + 3] = (byte)((intVal & 0xFFFFFFFFFF000000L) >> 24 & 0xFFL);
    }

    public static byte[] readNBytes(InputStream is, int n) throws IOException {
        int amt;
        byte[] b = new byte[n];
        for (int left = n; left > 0; left -= amt) {
            amt = is.read(b, n - left, left);
            if (amt != -1) continue;
            throw new EOFException("Short read");
        }
        return b;
    }

    public static byte[] readToNull(InputStream is) throws IOException {
        return ByteOp.readToNull(is, MAX_READ_SIZE);
    }

    public static byte[] readToNull(InputStream is, int maxSize) throws IOException {
        byte[] bytes = new byte[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            int b = is.read();
            if (b == -1) {
                throw new EOFException("NO NULL");
            }
            bytes[i] = (byte)(b & 0xFF);
            if (b != 0) continue;
            return ByteOp.copy(bytes, 0, i);
        }
        throw new IOException("Buffer too small");
    }

    public static int discardToNull(InputStream is) throws IOException {
        int b;
        int i = 0;
        do {
            if ((b = is.read()) == -1) {
                throw new EOFException("No NULL before EOF");
            }
            ++i;
        } while (b != 0);
        return i;
    }

    public static String drawHex(byte[] b) {
        return ByteOp.drawHex(b, b.length);
    }

    public static String drawHex(byte[] b, int bytesPerRow) {
        return ByteOp.drawHex(b, 0, b.length, bytesPerRow);
    }

    public static String drawHex(byte[] b, int offset, int length, int bytesPerRow) {
        int rows = (int)Math.ceil(length / bytesPerRow);
        if (rows == 0) {
            rows = 1;
        }
        int bytesToOutput = length;
        int position = 0;
        StringBuilder sb = new StringBuilder(length * 3 + rows);
        for (int row = 0; row < rows; ++row) {
            int bytesThisRow = Math.min(bytesToOutput, bytesPerRow);
            for (int col = 0; col < bytesThisRow; ++col) {
                String hex;
                if ((hex = Integer.toHexString(b[position++] & 0xFF)).length() == 2) {
                    sb.append(hex);
                    continue;
                }
                sb.append("0").append(hex);
            }
            bytesToOutput -= bytesThisRow;
        }
        return sb.toString();
    }

    public byte[] readFile(File f) throws FileNotFoundException, IOException {
        long lengthL = f.length();
        if (lengthL > Integer.MAX_VALUE) {
            throw new IOException("File too big to read into buffer..");
        }
        return ByteOp.readNBytes(new FileInputStream(f), (int)lengthL);
    }
}

