/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class CRCInputStream
extends InputStream {
    private InputStream is = null;
    private CRC32 crc = null;
    private long count = 0L;

    public CRCInputStream(InputStream is) {
        this(is, new CRC32());
    }

    public CRCInputStream(InputStream is, CRC32 crc) {
        this.is = is;
        this.crc = crc;
        this.count = 0L;
    }

    @Override
    public int read() throws IOException {
        int b = this.is.read();
        if (b != -1) {
            this.crc.update(b);
            ++this.count;
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int amt = this.is.read(b, off, len);
        if (amt > -1) {
            this.count += (long)amt;
            this.crc.update(b, off, amt);
        }
        return amt;
    }

    public long getCRCValue() {
        return this.crc.getValue();
    }

    public long getByteCount() {
        return this.count;
    }
}

