/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.net;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.nutch.net.URLFilter;
import org.apache.nutch.net.URLFilters;
import org.apache.nutch.util.AbstractChecker;
import org.apache.nutch.util.NutchConfiguration;

public class URLFilterChecker
extends AbstractChecker {
    private URLFilters filters = null;

    public int run(String[] args) throws Exception {
        this.usage = "Usage: URLFilterChecker [-Dproperty=value]... [-filterName filterName] (-stdin | -listen <port> [-keepClientCnxOpen]) \n\n  -filterName\tURL filter plugin name (eg. urlfilter-regex) to check,\n             \t(if not given all configured URL filters are applied)\n  -stdin     \ttool reads a list of URLs from stdin, one URL per line\n  -listen <port>\trun tool as Telnet server listening on <port>\n";
        if (args.length < 1) {
            System.err.println(this.usage);
            return -1;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-filterName")) {
                this.getConf().set("plugin.includes", args[++i]);
                continue;
            }
            int numConsumed = super.parseArgs(args, i);
            if (numConsumed > 0) {
                i += numConsumed - 1;
                continue;
            }
            System.err.println("ERROR: Not a recognized argument: " + args[i]);
            System.err.println(this.usage);
            return -1;
        }
        this.filters = new URLFilters(this.getConf());
        System.out.print("Checking combination of these URLFilters: ");
        for (URLFilter filter : this.filters.getFilters()) {
            System.out.print(filter.getClass().getSimpleName() + " ");
        }
        System.out.println("");
        return super.run();
    }

    @Override
    protected int process(String line, StringBuilder output) throws Exception {
        String out = this.filters.filter(line);
        if (out != null) {
            output.append("+");
            output.append(out);
        } else {
            output.append("-");
            output.append(line);
        }
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)NutchConfiguration.create(), (Tool)new URLFilterChecker(), (String[])args);
        System.exit(res);
    }
}

