/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.operation;

import com.hazelcast.internal.iteration.IterationResult;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.iterator.EntryViewsWithCursor;
import com.hazelcast.replicatedmap.impl.iterator.ReplicatedMapIterationService;
import com.hazelcast.replicatedmap.impl.operation.AbstractNamedSerializableOperation;
import com.hazelcast.replicatedmap.impl.record.ReplicatedMapEntryViewHolder;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import java.io.IOException;
import java.util.UUID;

public class FetchEntryViewsOperation
extends AbstractNamedSerializableOperation
implements ReadonlyOperation {
    private String name;
    private int partitionId;
    private UUID cursorId;
    private int batchSize;
    private boolean newIteration;
    private Object response;

    public FetchEntryViewsOperation() {
    }

    public FetchEntryViewsOperation(String name, int partitionId, UUID cursorId, int batchSize, boolean newIteration) {
        this.name = name;
        this.partitionId = partitionId;
        this.cursorId = cursorId;
        this.batchSize = batchSize;
        this.newIteration = newIteration;
    }

    @Override
    public int getClassId() {
        return 29;
    }

    @Override
    public void run() throws Exception {
        ReplicatedMapService service = (ReplicatedMapService)this.getService();
        ReplicatedMapIterationService iterationService = service.getIterationService();
        if (this.newIteration) {
            iterationService.createIterator(this.name, this.partitionId, this.cursorId);
        }
        IterationResult<ReplicatedMapEntryViewHolder> result = iterationService.iterate(this.cursorId, this.batchSize);
        this.response = new EntryViewsWithCursor(result.getPage(), result.getCursorId());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeInt(this.partitionId);
        UUIDSerializationUtil.writeUUID(out, this.cursorId);
        out.writeInt(this.batchSize);
        out.writeBoolean(this.newIteration);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.partitionId = in.readInt();
        this.cursorId = UUIDSerializationUtil.readUUID(in);
        this.batchSize = in.readInt();
        this.newIteration = in.readBoolean();
    }
}

