/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.room.wb;

import com.github.openjson.JSONObject;
import com.github.openjson.JSONStringer;
import java.util.function.Predicate;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.util.NullStringer;
import org.apache.openmeetings.util.ws.IClusterWsMessage;
import org.apache.openmeetings.web.room.RoomPreviewResourceReference;
import org.apache.openmeetings.web.room.RoomResourceReference;
import org.apache.openmeetings.web.room.wb.WbAction;
import org.apache.openmeetings.web.room.wb.WsMessageWb;
import org.apache.openmeetings.web.room.wb.WsMessageWbFile;
import org.apache.openmeetings.web.user.record.Mp4RecordingResourceReference;
import org.apache.openmeetings.web.user.record.PngRecordingResourceReference;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceReferenceRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;

public class WbWebSocketHelper {
    public static final String PARAM_OBJ = "obj";
    private static final String PARAM_POSTER_UND = "_poster";

    private WbWebSocketHelper() {
    }

    public static boolean send(IClusterWsMessage inMsg) {
        if (inMsg instanceof WsMessageWb) {
            WsMessageWb msg = (WsMessageWb)inMsg;
            if (msg.getUid() == null) {
                WbWebSocketHelper.sendWbAll(msg.getRoomId(), msg.getMeth(), msg.getObj(), false);
            } else {
                WbWebSocketHelper.sendWbOthers(msg.getRoomId(), msg.getMeth(), msg.getObj(), msg.getUid(), false);
            }
            return true;
        }
        if (inMsg instanceof WsMessageWbFile) {
            WsMessageWbFile fileMsg = (WsMessageWbFile)inMsg;
            WbWebSocketHelper.sendWbFile(fileMsg.getRoomId(), fileMsg.getWbId(), fileMsg.getRoomUid(), fileMsg.getFile(), fileMsg.getFileItem(), false);
            return true;
        }
        return false;
    }

    public static void sendWbAll(Long roomId, WbAction meth, JSONObject obj) {
        WbWebSocketHelper.sendWbAll(roomId, meth, obj, true);
    }

    private static void sendWbAll(Long roomId, WbAction meth, JSONObject obj, boolean publish) {
        if (publish) {
            WebSocketHelper.publish((IClusterWsMessage)new WsMessageWb(roomId, meth, obj, null));
        }
        WbWebSocketHelper.sendWb(roomId, meth, obj, WebSocketHelper.alwaysTrue());
    }

    public static void sendWbOthers(Long roomId, WbAction meth, JSONObject obj, String uid) {
        WbWebSocketHelper.sendWbOthers(roomId, meth, obj, uid, true);
    }

    private static void sendWbOthers(Long roomId, WbAction meth, JSONObject obj, String uid, boolean publish) {
        if (publish) {
            WebSocketHelper.publish((IClusterWsMessage)new WsMessageWb(roomId, meth, obj, uid));
        }
        WbWebSocketHelper.sendWb(roomId, meth, obj, c -> !uid.equals(c.getUid()));
    }

    public static JSONObject getWbJson(Long wbId) {
        return new JSONObject().put("wbId", (Object)wbId);
    }

    public static JSONObject getObjWbJson(Long wbId, Object o) {
        return WbWebSocketHelper.getWbJson(wbId).put(PARAM_OBJ, o);
    }

    private static CharSequence urlFor(ResourceReference ref, PageParameters params) {
        RequestCycle rc = RequestCycle.get();
        ResourceReferenceRequestHandler handler = new ResourceReferenceRequestHandler(ref, params);
        return rc.getUrlRenderer().renderContextRelativeUrl(rc.mapUrlFor((IRequestHandler)handler).toString());
    }

    public static JSONObject addFileUrl(String ruid, JSONObject inFile, BaseFileItem fi, Client c) {
        JSONObject file = new JSONObject(inFile.toString((JSONStringer)new NullStringer()));
        PageParameters pp = new PageParameters().add("id", (Object)fi.getId()).add("ruid", (Object)ruid).add("wuid", (Object)inFile.optString("uid"));
        if (c != null) {
            pp.add("uid", (Object)c.getUid());
        }
        file.put("deleted", !fi.exists());
        switch (fi.getType()) {
            case VIDEO: {
                RoomResourceReference ref = new RoomResourceReference();
                file.put("_src", (Object)WbWebSocketHelper.urlFor((ResourceReference)ref, pp));
                file.put(PARAM_POSTER_UND, (Object)WbWebSocketHelper.urlFor((ResourceReference)new RoomPreviewResourceReference(), pp));
                break;
            }
            case RECORDING: {
                Mp4RecordingResourceReference ref = new Mp4RecordingResourceReference();
                file.put("_src", (Object)WbWebSocketHelper.urlFor((ResourceReference)ref, pp));
                file.put(PARAM_POSTER_UND, (Object)WbWebSocketHelper.urlFor((ResourceReference)new PngRecordingResourceReference(), pp));
                break;
            }
            case PRESENTATION: {
                RoomResourceReference ref = new RoomResourceReference();
                file.put("_src", (Object)WbWebSocketHelper.urlFor((ResourceReference)ref, pp));
                break;
            }
            default: {
                RoomResourceReference ref = new RoomResourceReference();
                file.put("src", (Object)WbWebSocketHelper.urlFor((ResourceReference)ref, pp));
            }
        }
        return file;
    }

    public static void sendWbFile(Long roomId, long wbId, String ruid, JSONObject file, BaseFileItem fi) {
        WbWebSocketHelper.sendWbFile(roomId, wbId, ruid, file, fi, true);
    }

    private static String patchUrl(String url, Client c) {
        return url + "&uid=" + c.getUid();
    }

    private static JSONObject patchUrls(BaseFileItem fi, Client c, JSONObject inFile) {
        JSONObject f = new JSONObject(inFile.toString());
        switch (fi.getType()) {
            case VIDEO: 
            case RECORDING: {
                f.put("_src", (Object)WbWebSocketHelper.patchUrl(f.getString("_src"), c));
                f.put(PARAM_POSTER_UND, (Object)WbWebSocketHelper.patchUrl(f.getString(PARAM_POSTER_UND), c));
                break;
            }
            case PRESENTATION: {
                f.put("_src", (Object)WbWebSocketHelper.patchUrl(f.getString("_src"), c));
                break;
            }
            default: {
                f.put("src", (Object)WbWebSocketHelper.patchUrl(f.getString("src"), c));
            }
        }
        return f;
    }

    private static void sendWbFile(Long roomId, long wbId, String ruid, JSONObject file, BaseFileItem fi, boolean publish) {
        if (publish) {
            WebSocketHelper.publish((IClusterWsMessage)new WsMessageWbFile(roomId, wbId, ruid, file, fi));
        }
        JSONObject f = WbWebSocketHelper.addFileUrl(ruid, file, fi, null);
        WebSocketHelper.sendRoom((Long)roomId, (JSONObject)new JSONObject().put("type", (Object)"wb"), (Predicate)WebSocketHelper.alwaysTrue(), (o, c) -> o.put("func", (Object)WbAction.CREATE_OBJ.jsName()).put("param", (Object)WbWebSocketHelper.getObjWbJson(wbId, WbWebSocketHelper.patchUrls(fi, c, f))));
    }

    private static void sendWb(Long roomId, WbAction meth, JSONObject obj, Predicate<Client> check) {
        WebSocketHelper.sendRoom((Long)roomId, (JSONObject)new JSONObject().put("type", (Object)"wb"), check, (o, c) -> o.put("func", (Object)meth.jsName()).put("param", (Object)obj));
    }
}

