/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.internal.util.Timer;
import com.hazelcast.map.impl.operation.BasePutOperation;
import com.hazelcast.map.impl.operation.BaseRemoveOperation;
import com.hazelcast.map.impl.operation.GetOperation;
import com.hazelcast.map.impl.operation.SetOperation;
import com.hazelcast.map.impl.tx.TxnDeleteOperation;
import com.hazelcast.map.impl.tx.TxnSetOperation;
import com.hazelcast.spi.impl.operationservice.Operation;

public final class MapOperationStatsUpdater {
    private MapOperationStatsUpdater() {
    }

    public static void incrementOperationStats(Operation operation, LocalMapStatsImpl localMapStats, long startTimeNanos) {
        long durationNanos = Timer.nanosElapsed(startTimeNanos);
        if (operation instanceof SetOperation) {
            localMapStats.incrementSetLatencyNanos(durationNanos);
            return;
        }
        if (operation instanceof BasePutOperation) {
            localMapStats.incrementPutLatencyNanos(durationNanos);
            return;
        }
        if (operation instanceof BaseRemoveOperation) {
            localMapStats.incrementRemoveLatencyNanos(durationNanos);
            return;
        }
        if (operation instanceof GetOperation) {
            localMapStats.incrementGetLatencyNanos(durationNanos);
            return;
        }
    }

    public static void incrementTxnOperationStats(Operation operation, LocalMapStatsImpl localMapStats, long startTimeNanos) {
        long durationNanos = Timer.nanosElapsed(startTimeNanos);
        if (operation instanceof TxnSetOperation) {
            localMapStats.incrementSetLatencyNanos(durationNanos);
            return;
        }
        if (operation instanceof TxnDeleteOperation) {
            localMapStats.incrementRemoveLatencyNanos(durationNanos);
            return;
        }
        if (operation instanceof GetOperation) {
            localMapStats.incrementGetLatencyNanos(durationNanos);
            return;
        }
    }
}

