/*
 * Decompiled with CFR 0.152.
 */
package io.oxia.client.notify;

import io.grpc.stub.StreamObserver;
import io.oxia.client.CompositeConsumer;
import io.oxia.client.api.Notification;
import io.oxia.client.grpc.OxiaStub;
import io.oxia.client.grpc.OxiaStubManager;
import io.oxia.client.notify.NotificationManager;
import io.oxia.client.util.Backoff;
import io.oxia.proto.NotificationBatch;
import io.oxia.proto.NotificationsRequest;
import java.io.Closeable;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardNotificationReceiver
implements Closeable,
StreamObserver<NotificationBatch> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShardNotificationReceiver.class);
    private final OxiaStub stub;
    private final NotificationManager notificationManager;
    private final long shardId;
    @NonNull
    private final Consumer<Notification> callback;
    @NonNull
    private volatile OptionalLong offset;
    private volatile boolean closed = false;
    private final Backoff backoff = new Backoff();

    ShardNotificationReceiver(@NonNull OxiaStub stub, long shardId, @NonNull Consumer<Notification> callback, NotificationManager notificationManager, @NonNull OptionalLong offset) {
        if (stub == null) {
            throw new NullPointerException("stub is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (offset == null) {
            throw new NullPointerException("offset is marked non-null but is null");
        }
        this.stub = stub;
        this.notificationManager = notificationManager;
        this.shardId = shardId;
        this.callback = callback;
        this.offset = offset;
        this.start();
    }

    void start() {
        NotificationsRequest.Builder request = NotificationsRequest.newBuilder().setShard(this.shardId);
        this.offset.ifPresent(request::setStartOffsetExclusive);
        this.stub.async().getNotifications(request.build(), this);
    }

    public void onNext(NotificationBatch batch) {
        if (this.offset.isPresent() && this.offset.getAsLong() >= batch.getOffset()) {
            return;
        }
        this.offset = OptionalLong.of(batch.getOffset());
        this.notificationManager.getCounterNotificationsBatchesReceived().increment();
        this.notificationManager.getCounterNotificationsReceived().add(batch.getNotificationsCount());
        batch.getNotificationsMap().forEach((key, notification) -> {
            Notification.KeyCreated n;
            if (log.isDebugEnabled()) {
                log.debug("--- Got notification: {} - {}", key, (Object)notification.getType());
            }
            switch (notification.getType()) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case KEY_CREATED: {
                    Notification.KeyCreated keyCreated = new Notification.KeyCreated(key, notification.getVersionId());
                    break;
                }
                case KEY_MODIFIED: {
                    Notification.KeyCreated keyCreated = new Notification.KeyModified(key, notification.getVersionId());
                    break;
                }
                case KEY_DELETED: {
                    Notification.KeyCreated keyCreated = new Notification.KeyDeleted(key);
                    break;
                }
                case KEY_RANGE_DELETED: {
                    Notification.KeyCreated keyCreated = new Notification.KeyRangeDelete(key, notification.getKeyRangeLast());
                    break;
                }
                case UNRECOGNIZED: {
                    Notification.KeyCreated keyCreated = n = null;
                }
            }
            if (n != null) {
                this.callback.accept((Notification)n);
            }
        });
    }

    public void onError(Throwable t) {
        if (this.closed) {
            return;
        }
        long retryDelayMillis = this.backoff.nextDelayMillis();
        log.warn("Error while receiving notifications for shard={}: {} - Retrying in {} seconds", new Object[]{this.shardId, t.getMessage(), (double)retryDelayMillis / 1000.0});
        this.notificationManager.getExecutor().schedule(() -> {
            if (!this.closed) {
                log.info("Retrying getting notifications for shard={}", (Object)this.shardId);
                this.start();
            }
        }, retryDelayMillis, TimeUnit.MILLISECONDS);
    }

    public void onCompleted() {
        if (!this.closed) {
            this.start();
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Generated
    long getShardId() {
        return this.shardId;
    }

    @NonNull
    @Generated
    public OptionalLong getOffset() {
        return this.offset;
    }

    static class Factory {
        @NonNull
        private final OxiaStubManager stubManager;
        @NonNull
        private final CompositeConsumer<Notification> callback = new CompositeConsumer();

        @NonNull
        ShardNotificationReceiver newReceiver(long shardId, @NonNull String leader, @NonNull NotificationManager notificationManager, @NonNull OptionalLong offset) {
            if (leader == null) {
                throw new NullPointerException("leader is marked non-null but is null");
            }
            if (notificationManager == null) {
                throw new NullPointerException("notificationManager is marked non-null but is null");
            }
            if (offset == null) {
                throw new NullPointerException("offset is marked non-null but is null");
            }
            return new ShardNotificationReceiver(this.stubManager.getStub(leader), shardId, this.callback, notificationManager, offset);
        }

        @Generated
        Factory(@NonNull OxiaStubManager stubManager) {
            if (stubManager == null) {
                throw new NullPointerException("stubManager is marked non-null but is null");
            }
            this.stubManager = stubManager;
        }

        @NonNull
        @Generated
        public CompositeConsumer<Notification> getCallback() {
            return this.callback;
        }
    }
}

