/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.netty.buffer.ByteBuf;
import io.prometheus.client.Gauge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.impl.AckSetStateUtil;
import org.apache.bookkeeper.mledger.util.PositionAckSetUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.intercept.BrokerInterceptor;
import org.apache.pulsar.broker.service.AbstractTopic;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.Dispatcher;
import org.apache.pulsar.broker.service.EntryAndMetadata;
import org.apache.pulsar.broker.service.EntryBatchIndexesAcks;
import org.apache.pulsar.broker.service.EntryBatchSizes;
import org.apache.pulsar.broker.service.EntryFilterSupport;
import org.apache.pulsar.broker.service.SendMessageInfo;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.Topic;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.PersistentSubscription;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.service.persistent.PulsarCompactorSubscription;
import org.apache.pulsar.broker.service.plugin.EntryFilter;
import org.apache.pulsar.broker.transaction.pendingack.impl.PendingAckHandleImpl;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.api.proto.CommandAck;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.api.proto.ReplicatedSubscriptionsSnapshot;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.Markers;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseDispatcher
extends EntryFilterSupport
implements Dispatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractBaseDispatcher.class);
    private static final Gauge PENDING_BYTES_TO_DISPATCH = (Gauge)((Gauge.Builder)((Gauge.Builder)Gauge.build().name("pulsar_broker_pending_bytes_to_dispatch")).help("Amount of bytes loaded in memory to be dispatched to Consumers")).register();
    protected final ServiceConfiguration serviceConfig;
    protected final boolean dispatchThrottlingOnBatchMessageEnabled;
    private final LongAdder filterProcessedMsgs = new LongAdder();
    private final LongAdder filterAcceptedMsgs = new LongAdder();
    private final LongAdder filterRejectedMsgs = new LongAdder();
    private final LongAdder filterRescheduledMsgs = new LongAdder();
    private final LongAdder dispatchThrottledMsgEventsBySubscriptionLimit = new LongAdder();
    private final LongAdder dispatchThrottledMsgEventsByTopicLimit = new LongAdder();
    private final LongAdder dispatchThrottledMsgEventsByBrokerLimit = new LongAdder();
    private final LongAdder dispatchThrottledBytesEventsBySubscriptionLimit = new LongAdder();
    private final LongAdder dispatchThrottledBytesEventsByTopicLimit = new LongAdder();
    private final LongAdder dispatchThrottledBytesEventsByBrokerLimit = new LongAdder();

    protected AbstractBaseDispatcher(Subscription subscription, ServiceConfiguration serviceConfig) {
        super(subscription);
        this.serviceConfig = serviceConfig;
        this.dispatchThrottlingOnBatchMessageEnabled = serviceConfig.isDispatchThrottlingOnBatchMessageEnabled();
    }

    public int filterEntriesForConsumer(List<? extends Entry> entries, EntryBatchSizes batchSizes, SendMessageInfo sendMessageInfo, EntryBatchIndexesAcks indexesAcks, ManagedCursor cursor, boolean isReplayRead, Consumer consumer) {
        return this.filterEntriesForConsumer(null, 0, entries, batchSizes, sendMessageInfo, indexesAcks, cursor, isReplayRead, consumer);
    }

    public int filterEntriesForConsumer(@Nullable MessageMetadata[] metadataArray, int startOffset, List<? extends Entry> entries, EntryBatchSizes batchSizes, SendMessageInfo sendMessageInfo, EntryBatchIndexesAcks indexesAcks, ManagedCursor cursor, boolean isReplayRead, Consumer consumer) {
        int totalMessages = 0;
        long totalBytes = 0L;
        int totalChunkedMessages = 0;
        int totalEntries = 0;
        int filteredMessageCount = 0;
        int filteredEntryCount = 0;
        long filteredBytesCount = 0L;
        ArrayList<Position> entriesToFiltered = this.hasFilter ? new ArrayList<Position>() : null;
        ArrayList<Position> entriesToRedeliver = this.hasFilter ? new ArrayList<Position>() : null;
        int entriesSize = entries.size();
        for (int i = 0; i < entriesSize; ++i) {
            EntryFilter.FilterResult filterResult;
            int entryMsgCnt;
            Entry entry = entries.get(i);
            if (entry == null) continue;
            ByteBuf metadataAndPayload = entry.getDataBuffer();
            int metadataIndex = i + startOffset;
            MessageMetadata msgMetadata = metadataArray != null ? metadataArray[metadataIndex] : (entry instanceof EntryAndMetadata ? ((EntryAndMetadata)entry).getMetadata() : (entry.getMessageMetadata() != null ? entry.getMessageMetadata() : Commands.peekAndCopyMessageMetadata((ByteBuf)metadataAndPayload, (String)this.subscription.toString(), (long)-1L)));
            int n = entryMsgCnt = msgMetadata == null ? 1 : msgMetadata.getNumMessagesInBatch();
            if (this.hasFilter) {
                this.filterProcessedMsgs.add(entryMsgCnt);
            }
            if ((filterResult = this.runFiltersForEntry(entry, msgMetadata, consumer)) == EntryFilter.FilterResult.REJECT) {
                entriesToFiltered.add(entry.getPosition());
                entries.set(i, null);
                this.filterRejectedMsgs.add(entryMsgCnt);
                ++filteredEntryCount;
                filteredMessageCount += entryMsgCnt;
                filteredBytesCount += (long)metadataAndPayload.readableBytes();
                entry.release();
                continue;
            }
            if (filterResult == EntryFilter.FilterResult.RESCHEDULE) {
                entriesToRedeliver.add(entry.getPosition());
                entries.set(i, null);
                this.filterRescheduledMsgs.add(entryMsgCnt);
                ++filteredEntryCount;
                filteredMessageCount += entryMsgCnt;
                filteredBytesCount += (long)metadataAndPayload.readableBytes();
                entry.release();
                continue;
            }
            if (msgMetadata != null && msgMetadata.hasTxnidMostBits() && msgMetadata.hasTxnidLeastBits()) {
                if (Markers.isTxnMarker((MessageMetadata)msgMetadata)) {
                    if (cursor == null || !cursor.getName().equals("__compaction")) {
                        this.individualAcknowledgeMessageIfNeeded(Collections.singletonList(entry.getPosition()), Collections.emptyMap());
                        entries.set(i, null);
                        entry.release();
                        continue;
                    }
                } else if (((PersistentTopic)this.subscription.getTopic()).isTxnAborted(new TxnID(msgMetadata.getTxnidMostBits(), msgMetadata.getTxnidLeastBits()), entry.getPosition())) {
                    this.individualAcknowledgeMessageIfNeeded(Collections.singletonList(entry.getPosition()), Collections.emptyMap());
                    entries.set(i, null);
                    entry.release();
                    continue;
                }
            }
            if (msgMetadata == null || Markers.isServerOnlyMarker((MessageMetadata)msgMetadata)) {
                Position pos = entry.getPosition();
                if (Markers.isReplicatedSubscriptionSnapshotMarker((MessageMetadata)msgMetadata)) {
                    int readerIndex = metadataAndPayload.readerIndex();
                    this.processReplicatedSubscriptionSnapshot(pos, metadataAndPayload);
                    metadataAndPayload.readerIndex(readerIndex);
                }
                if (msgMetadata == null || cursor == null || !cursor.getName().equals("__compaction")) {
                    entries.set(i, null);
                    entry.release();
                    this.individualAcknowledgeMessageIfNeeded(Collections.singletonList(pos), Collections.emptyMap());
                    continue;
                }
            } else if (this.trackDelayedDelivery(entry.getLedgerId(), entry.getEntryId(), msgMetadata)) {
                entries.set(i, null);
                entry.release();
                continue;
            }
            if (this.hasFilter) {
                this.filterAcceptedMsgs.add(entryMsgCnt);
            }
            int batchSize = msgMetadata.getNumMessagesInBatch();
            long[] ackSet = null;
            if (indexesAcks != null && cursor != null) {
                Position positionInPendingAck;
                Position position = PositionFactory.create((long)entry.getLedgerId(), (long)entry.getEntryId());
                ackSet = cursor.getDeletedBatchIndexesAsLongArray(position);
                if (this.subscription instanceof PersistentSubscription && ((PersistentSubscription)this.subscription).getPendingAckHandle() instanceof PendingAckHandleImpl && (positionInPendingAck = ((PersistentSubscription)this.subscription).getPositionInPendingAck(position)) != null) {
                    long[] pendingAckSet = AckSetStateUtil.getAckSetArrayOrNull((Position)positionInPendingAck);
                    if (pendingAckSet != null) {
                        if (PositionAckSetUtil.isAckSetEmpty((long[])(ackSet = ackSet != null ? PositionAckSetUtil.andAckSet((long[])ackSet, (long[])pendingAckSet) : pendingAckSet))) {
                            entries.set(i, null);
                            entry.release();
                            continue;
                        }
                    } else {
                        entries.set(i, null);
                        entry.release();
                        continue;
                    }
                }
                if (ackSet != null) {
                    indexesAcks.setIndexesAcks(i, (Pair<Integer, long[]>)Pair.of((Object)batchSize, (Object)ackSet));
                } else {
                    indexesAcks.setIndexesAcks(i, null);
                }
            }
            ++totalEntries;
            totalMessages += batchSize;
            totalBytes += (long)metadataAndPayload.readableBytes();
            totalChunkedMessages += msgMetadata.hasChunkId() ? 1 : 0;
            batchSizes.setBatchSize(i, batchSize);
            BrokerInterceptor interceptor = this.subscription.interceptor();
            if (null == interceptor) continue;
            interceptor.beforeSendMessage(this.subscription, entry, ackSet, msgMetadata);
            interceptor.beforeSendMessage(this.subscription, entry, ackSet, msgMetadata, consumer);
        }
        if (CollectionUtils.isNotEmpty(entriesToFiltered)) {
            this.individualAcknowledgeMessageIfNeeded(entriesToFiltered, Collections.emptyMap());
            int filtered = entriesToFiltered.size();
            Topic topic = this.subscription.getTopic();
            if (topic instanceof AbstractTopic) {
                ((AbstractTopic)topic).addFilteredEntriesCount(filtered);
            }
        }
        if (CollectionUtils.isNotEmpty(entriesToRedeliver)) {
            this.subscription.getTopic().getBrokerService().getPulsar().getExecutor().schedule(() -> this.subscription.redeliverUnacknowledgedMessages(consumer, entriesToRedeliver), (long)this.serviceConfig.getDispatcherEntryFilterRescheduledMessageDelay(), TimeUnit.MILLISECONDS);
        }
        if (this.serviceConfig.isDispatchThrottlingForFilteredEntriesEnabled()) {
            this.acquirePermitsForDeliveredMessages(this.subscription.getTopic(), cursor, filteredEntryCount, filteredMessageCount, filteredBytesCount);
        }
        sendMessageInfo.setTotalMessages(totalMessages);
        sendMessageInfo.setTotalBytes(totalBytes);
        sendMessageInfo.setTotalChunkedMessages(totalChunkedMessages);
        return totalEntries;
    }

    private void individualAcknowledgeMessageIfNeeded(List<Position> positions, Map<String, Long> properties) {
        if (!(this.subscription instanceof PulsarCompactorSubscription)) {
            this.subscription.acknowledgeMessage(positions, CommandAck.AckType.Individual, properties);
        }
    }

    protected void acquirePermitsForDeliveredMessages(Topic topic, ManagedCursor cursor, long totalEntries, long totalMessagesSent, long totalBytesSent) {
        if (this.serviceConfig.isDispatchThrottlingOnNonBacklogConsumerEnabled() || cursor != null && !cursor.isActive()) {
            long permits = this.dispatchThrottlingOnBatchMessageEnabled ? totalEntries : totalMessagesSent;
            topic.getBrokerDispatchRateLimiter().ifPresent(rateLimiter -> rateLimiter.consumeDispatchQuota(permits, totalBytesSent));
            topic.getDispatchRateLimiter().ifPresent(rateLimter -> rateLimter.consumeDispatchQuota(permits, totalBytesSent));
            this.getRateLimiter().ifPresent(rateLimiter -> rateLimiter.consumeDispatchQuota(permits, totalBytesSent));
        }
    }

    protected abstract boolean isConsumersExceededOnSubscription();

    protected boolean isConsumersExceededOnSubscription(AbstractTopic topic, int consumerSize) {
        if (topic.isSystemTopic()) {
            return false;
        }
        Integer maxConsumersPerSubscription = (Integer)topic.getHierarchyTopicPolicies().getMaxConsumersPerSubscription().get();
        return maxConsumersPerSubscription != null && maxConsumersPerSubscription > 0 && maxConsumersPerSubscription <= consumerSize;
    }

    private void processReplicatedSubscriptionSnapshot(Position pos, ByteBuf headersAndPayload) {
        Commands.skipMessageMetadata((ByteBuf)headersAndPayload);
        try {
            ReplicatedSubscriptionsSnapshot snapshot = Markers.parseReplicatedSubscriptionsSnapshot((ByteBuf)headersAndPayload);
            this.subscription.processReplicatedSubscriptionSnapshot(snapshot);
        }
        catch (Throwable t) {
            log.warn("Failed to process replicated subscription snapshot at {} -- {}", new Object[]{pos, t.getMessage(), t});
            return;
        }
    }

    @Override
    public void resetCloseFuture() {
    }

    protected abstract void reScheduleRead();

    public abstract String getName();

    protected boolean hasAnyDispatchRateLimiter() {
        return this.subscription.getTopic().getBrokerDispatchRateLimiter().isPresent() || this.subscription.getTopic().getDispatchRateLimiter().isPresent() || this.getRateLimiter().isPresent();
    }

    protected Pair<Integer, Long> applyRateLimitsToMessagesAndBytesToRead(int messagesToRead, long bytesToRead) {
        MutablePair readLimits = new MutablePair((Object)messagesToRead, (Object)bytesToRead);
        Topic topic = this.subscription.getTopic();
        boolean success = true;
        if (topic.getBrokerDispatchRateLimiter().isPresent()) {
            success = this.applyDispatchRateLimitsToReadLimits(topic.getBrokerDispatchRateLimiter().get(), (MutablePair<Integer, Long>)readLimits, DispatchRateLimiter.Type.BROKER);
        }
        if (success && topic.getDispatchRateLimiter().isPresent()) {
            success = this.applyDispatchRateLimitsToReadLimits(topic.getDispatchRateLimiter().get(), (MutablePair<Integer, Long>)readLimits, DispatchRateLimiter.Type.TOPIC);
        }
        if (success && this.getRateLimiter().isPresent()) {
            success = this.applyDispatchRateLimitsToReadLimits(this.getRateLimiter().get(), (MutablePair<Integer, Long>)readLimits, DispatchRateLimiter.Type.SUBSCRIPTION);
        }
        return readLimits;
    }

    private boolean applyDispatchRateLimitsToReadLimits(DispatchRateLimiter rateLimiter, MutablePair<Integer, Long> readLimits, DispatchRateLimiter.Type limiterType) {
        long availablePermitsOnByte;
        int originalMessagesToRead = (Integer)readLimits.getLeft();
        long originalBytesToRead = (Long)readLimits.getRight();
        int availablePermitsOnMsg = (int)rateLimiter.getAvailableDispatchRateLimitOnMsg();
        if (availablePermitsOnMsg >= 0) {
            readLimits.setLeft((Object)Math.min((Integer)readLimits.getLeft(), availablePermitsOnMsg));
        }
        if ((availablePermitsOnByte = rateLimiter.getAvailableDispatchRateLimitOnByte()) >= 0L) {
            readLimits.setRight((Object)Math.min((Long)readLimits.getRight(), availablePermitsOnByte));
        }
        if ((Integer)readLimits.getLeft() < originalMessagesToRead) {
            switch (limiterType) {
                case BROKER: {
                    this.dispatchThrottledMsgEventsByBrokerLimit.increment();
                    break;
                }
                case TOPIC: {
                    this.dispatchThrottledMsgEventsByTopicLimit.increment();
                    break;
                }
                case SUBSCRIPTION: {
                    this.dispatchThrottledMsgEventsBySubscriptionLimit.increment();
                    break;
                }
            }
        }
        if ((Long)readLimits.getRight() < originalBytesToRead) {
            switch (limiterType) {
                case BROKER: {
                    this.dispatchThrottledBytesEventsByBrokerLimit.increment();
                    break;
                }
                case TOPIC: {
                    this.dispatchThrottledBytesEventsByTopicLimit.increment();
                    break;
                }
                case SUBSCRIPTION: {
                    this.dispatchThrottledBytesEventsBySubscriptionLimit.increment();
                    break;
                }
            }
        }
        if ((Integer)readLimits.getLeft() == 0 || (Long)readLimits.getRight() == 0L) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] message-read exceeded {} message-rate {}/{}, schedule after {}ms", new Object[]{this.getName(), limiterType.name().toLowerCase(), rateLimiter.getDispatchRateOnMsg(), rateLimiter.getDispatchRateOnByte(), 1000});
            }
            this.reScheduleRead();
            readLimits.setLeft((Object)-1);
            readLimits.setRight((Object)-1L);
            return false;
        }
        return true;
    }

    protected byte[] peekStickyKey(Entry entry) {
        if (entry instanceof EntryAndMetadata) {
            EntryAndMetadata entryAndMetadata = (EntryAndMetadata)entry;
            return entryAndMetadata.getStickyKey();
        }
        MessageMetadata metadata = entry.getMessageMetadata();
        if (metadata == null) {
            metadata = Commands.peekMessageMetadata((ByteBuf)entry.getDataBuffer(), (String)this.subscription.toString(), (long)-1L);
        }
        if (metadata == null) {
            return Commands.NONE_KEY;
        }
        return Commands.resolveStickyKey((MessageMetadata)metadata);
    }

    protected String getSubscriptionName() {
        return this.subscription == null ? null : this.subscription.getName();
    }

    protected void checkAndApplyReachedEndOfTopicOrTopicMigration(List<Consumer> consumers) {
        PersistentTopic topic = (PersistentTopic)this.subscription.getTopic();
        AbstractBaseDispatcher.checkAndApplyReachedEndOfTopicOrTopicMigration(topic, consumers);
    }

    public static void checkAndApplyReachedEndOfTopicOrTopicMigration(PersistentTopic topic, List<Consumer> consumers) {
        if (topic.isMigrated()) {
            consumers.forEach(c -> c.topicMigrated(topic.getMigratedClusterUrl()));
        } else {
            consumers.forEach(Consumer::reachedEndOfTopic);
        }
    }

    @Override
    public long getFilterProcessedMsgCount() {
        return this.filterProcessedMsgs.longValue();
    }

    @Override
    public long getFilterAcceptedMsgCount() {
        return this.filterAcceptedMsgs.longValue();
    }

    @Override
    public long getFilterRejectedMsgCount() {
        return this.filterRejectedMsgs.longValue();
    }

    @Override
    public long getFilterRescheduledMsgCount() {
        return this.filterRescheduledMsgs.longValue();
    }

    @Override
    public long getDispatchThrottledMsgEventsBySubscriptionLimit() {
        return this.dispatchThrottledMsgEventsBySubscriptionLimit.longValue();
    }

    @Override
    public long getDispatchThrottledBytesBySubscriptionLimit() {
        return this.dispatchThrottledBytesEventsBySubscriptionLimit.longValue();
    }

    @Override
    public long getDispatchThrottledMsgEventsByTopicLimit() {
        return this.dispatchThrottledMsgEventsByTopicLimit.longValue();
    }

    @Override
    public long getDispatchThrottledBytesEventsByTopicLimit() {
        return this.dispatchThrottledBytesEventsByTopicLimit.longValue();
    }

    @Override
    public long getDispatchThrottledMsgEventsByBrokerLimit() {
        return this.dispatchThrottledMsgEventsByBrokerLimit.longValue();
    }

    @Override
    public long getDispatchThrottledBytesEventsByBrokerLimit() {
        return this.dispatchThrottledBytesEventsByBrokerLimit.longValue();
    }

    protected final void updatePendingBytesToDispatch(long size) {
        PENDING_BYTES_TO_DISPATCH.inc((double)size);
    }

    protected int getNumberOfMessagesInBatch(Entry entry) {
        MessageMetadata msgMetadata = entry.getMessageMetadata();
        if (msgMetadata == null) {
            msgMetadata = Commands.peekMessageMetadata((ByteBuf)entry.getDataBuffer(), (String)this.subscription.toString(), (long)-1L);
        }
        if (msgMetadata == null) {
            return -1;
        }
        return msgMetadata.getNumMessagesInBatch();
    }
}

