/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import java.util.Map;
import org.apache.qpid.server.filter.AMQInvalidArgumentException;
import org.apache.qpid.server.filter.AMQPFilterTypes;
import org.apache.qpid.server.filter.FilterManager;
import org.apache.qpid.server.filter.JMSSelectorFilter;
import org.apache.qpid.server.filter.SelectorParsingException;
import org.apache.qpid.server.filter.selector.ParseException;
import org.apache.qpid.server.filter.selector.TokenMgrError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterManagerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilterManagerFactory.class);

    private FilterManagerFactory() {
    }

    public static FilterManager createManager(Map<String, Object> filters) throws AMQInvalidArgumentException {
        FilterManager manager = null;
        if (filters != null) {
            Object selector;
            if (filters.containsKey(AMQPFilterTypes.JMS_SELECTOR.toString()) && (selector = filters.get(AMQPFilterTypes.JMS_SELECTOR.toString())) instanceof String && !selector.equals("")) {
                manager = new FilterManager();
                try {
                    JMSSelectorFilter filter = new JMSSelectorFilter((String)selector);
                    manager.add(filter.getName(), filter);
                }
                catch (SelectorParsingException | ParseException | TokenMgrError e) {
                    throw new AMQInvalidArgumentException("Cannot parse JMS selector \"" + String.valueOf(selector) + "\"", e);
                }
            }
        } else {
            LOGGER.debug("No Filters found.");
        }
        return manager;
    }
}

