/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.Trace;
import com.sleepycat.je.log.entry.SingleItemReplicableEntry;
import java.nio.ByteBuffer;

public class TraceLogEntry
extends SingleItemReplicableEntry<Trace> {
    private static final int LAST_FORMAT_CHANGE = 8;
    private static volatile Loggable testPriorItem = null;

    public TraceLogEntry() {
        super(Trace.class);
    }

    public TraceLogEntry(Trace trace) {
        super(LogEntryType.LOG_TRACE, trace);
    }

    public static void setTestPriorItem(Loggable priorItem) {
        testPriorItem = priorItem;
    }

    @Override
    public int getLastFormatChange() {
        return 8;
    }

    @Override
    public int getSize(int logVersion, boolean forReplication) {
        if (testPriorItem != null && logVersion == 7) {
            return testPriorItem.getLogSize();
        }
        return super.getSize(logVersion, forReplication);
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer, int logVersion, boolean forReplication) {
        if (testPriorItem != null && logVersion == 7) {
            testPriorItem.writeToLog(destBuffer);
            return;
        }
        super.writeEntry(destBuffer, logVersion, forReplication);
    }
}

