/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.url;

import java.net.URISyntaxException;

public class URLSyntaxException
extends URISyntaxException {
    private final int _length;

    public URLSyntaxException(String url, String error, int index, int length) {
        super(url, error, index);
        this._length = length;
    }

    private static String getPositionString(int index, int length) {
        int i;
        StringBuffer sb = new StringBuffer(index + 1);
        for (i = 0; i < index; ++i) {
            sb.append(" ");
        }
        if (length > -1) {
            for (i = 0; i < length; ++i) {
                sb.append('^');
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getReason());
        if (this.getIndex() > -1) {
            if (this._length != -1) {
                sb.append(" between indicies ");
                sb.append(this.getIndex());
                sb.append(" and ");
                sb.append(this._length);
            } else {
                sb.append(" at index ");
                sb.append(this.getIndex());
            }
        }
        sb.append(" ");
        if (this.getIndex() != -1) {
            sb.append("\n");
        }
        sb.append(this.getInput());
        if (this.getIndex() != -1) {
            sb.append("\n");
            sb.append(URLSyntaxException.getPositionString(this.getIndex(), this._length));
        }
        return sb.toString();
    }
}

