/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.TupleSerialMarshalledBinding;
import com.sleepycat.bind.serial.TupleSerialMarshalledKeyCreator;
import com.sleepycat.bind.tuple.MarshalledTupleKeyEntity;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleMarshalledBinding;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;

public class TupleSerialFactory {
    private ClassCatalog catalog;

    public TupleSerialFactory(ClassCatalog catalog) {
        this.catalog = catalog;
    }

    public final ClassCatalog getCatalog() {
        return this.catalog;
    }

    public <K, V extends MarshalledTupleKeyEntity> StoredMap<K, V> newMap(Database db, Class<K> keyClass, Class<V> valueBaseClass, boolean writeAllowed) {
        return new StoredMap<K, V>(db, this.getKeyBinding(keyClass), this.getEntityBinding(valueBaseClass), writeAllowed);
    }

    public <K, V extends MarshalledTupleKeyEntity> StoredSortedMap<K, V> newSortedMap(Database db, Class<K> keyClass, Class<V> valueBaseClass, boolean writeAllowed) {
        return new StoredSortedMap<K, V>(db, this.getKeyBinding(keyClass), this.getEntityBinding(valueBaseClass), writeAllowed);
    }

    public <V extends MarshalledTupleKeyEntity> TupleSerialMarshalledKeyCreator<V> getKeyCreator(Class<V> valueBaseClass, String keyName) {
        return new TupleSerialMarshalledKeyCreator<V>(this.getEntityBinding(valueBaseClass), keyName);
    }

    public <V extends MarshalledTupleKeyEntity> TupleSerialMarshalledBinding<V> getEntityBinding(Class<V> baseClass) {
        return new TupleSerialMarshalledBinding<V>(this.catalog, baseClass);
    }

    private <K> EntryBinding<K> getKeyBinding(Class<K> keyClass) {
        TupleBinding<K> binding = TupleBinding.getPrimitiveBinding(keyClass);
        if (binding == null) {
            binding = new TupleMarshalledBinding<K>(keyClass);
        }
        return binding;
    }
}

