/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ratis.conf.RaftProperties;
import org.apache.ratis.protocol.ClientId;
import org.apache.ratis.protocol.RaftClientRequest;
import org.apache.ratis.server.RaftServerConfigKeys;
import org.apache.ratis.thirdparty.com.google.common.cache.Cache;
import org.apache.ratis.thirdparty.com.google.common.cache.CacheBuilder;
import org.apache.ratis.util.TimeDuration;

class WriteIndexCache {
    private final Cache<ClientId, AtomicReference<CompletableFuture<Long>>> cache;

    WriteIndexCache(RaftProperties properties) {
        this(RaftServerConfigKeys.Read.ReadAfterWriteConsistent.writeIndexCacheExpiryTime(properties));
    }

    WriteIndexCache(TimeDuration cacheExpiryTime) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(cacheExpiryTime.getDuration(), cacheExpiryTime.getUnit()).build();
    }

    void add(ClientId key, CompletableFuture<Long> future) {
        AtomicReference ref;
        try {
            ref = this.cache.get(key, AtomicReference::new);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        ref.set(future);
    }

    CompletableFuture<Long> getWriteIndexFuture(RaftClientRequest request) {
        AtomicReference<CompletableFuture<Long>> ref;
        if (request != null && request.getType().getRead().getReadAfterWriteConsistent() && (ref = this.cache.getIfPresent(request.getClientId())) != null) {
            return ref.get();
        }
        return CompletableFuture.completedFuture(null);
    }
}

