/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.ch.qos.logback.classic.pattern;

import java.util.Map;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.pattern.ClassicConverter;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.spi.ILoggingEvent;
import org.apache.rocketmq.shaded.ch.qos.logback.classic.spi.LoggerContextVO;

public final class PropertyConverter
extends ClassicConverter {
    String key;

    @Override
    public void start() {
        String optStr = this.getFirstOption();
        if (optStr != null) {
            this.key = optStr;
            super.start();
        }
    }

    public String getKey() {
        return this.key;
    }

    @Override
    public String convert(ILoggingEvent event) {
        if (this.key == null) {
            return "Property_HAS_NO_KEY";
        }
        LoggerContextVO lcvo = event.getLoggerContextVO();
        Map<String, String> map = lcvo.getPropertyMap();
        String val = map.get(this.key);
        if (val != null) {
            return val;
        }
        return System.getProperty(this.key);
    }
}

