/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.rename;

import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.shade.com.fasterxml.jackson.annotation.JsonAlias;
import org.apache.seatunnel.transform.rename.ConvertCase;

public class TableRenameConfig
implements Serializable {
    public static final Option<ConvertCase> CONVERT_CASE = Options.key((String)"convert_case").enumType(ConvertCase.class).noDefaultValue().withDescription("Convert to uppercase or lowercase");
    public static final Option<String> PREFIX = Options.key((String)"prefix").stringType().noDefaultValue().withDescription("Add prefix for table name");
    public static final Option<String> SUFFIX = Options.key((String)"suffix").stringType().noDefaultValue().withDescription("Add suffix for table name");
    public static final Option<List<ReplacementsWithRegex>> REPLACEMENTS_WITH_REGEX = Options.key((String)"replacements_with_regex").listType(ReplacementsWithRegex.class).noDefaultValue().withDescription("The regex of replace table name to ");
    @JsonAlias(value={"convert_case"})
    private ConvertCase convertCase;
    @JsonAlias(value={"prefix"})
    private String prefix;
    @JsonAlias(value={"suffix"})
    private String suffix;
    @JsonAlias(value={"replacements_with_regex"})
    private List<ReplacementsWithRegex> replacementsWithRegex;

    public static TableRenameConfig of(ReadonlyConfig config) {
        TableRenameConfig renameConfig = new TableRenameConfig();
        renameConfig.setConvertCase((ConvertCase)((Object)config.get(CONVERT_CASE)));
        renameConfig.setPrefix((String)config.get(PREFIX));
        renameConfig.setSuffix((String)config.get(SUFFIX));
        renameConfig.setReplacementsWithRegex((List)config.get(REPLACEMENTS_WITH_REGEX));
        return renameConfig;
    }

    public ConvertCase getConvertCase() {
        return this.convertCase;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public List<ReplacementsWithRegex> getReplacementsWithRegex() {
        return this.replacementsWithRegex;
    }

    public TableRenameConfig setConvertCase(ConvertCase convertCase) {
        this.convertCase = convertCase;
        return this;
    }

    public TableRenameConfig setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public TableRenameConfig setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public TableRenameConfig setReplacementsWithRegex(List<ReplacementsWithRegex> replacementsWithRegex) {
        this.replacementsWithRegex = replacementsWithRegex;
        return this;
    }

    public static class ReplacementsWithRegex
    implements Serializable {
        @JsonAlias(value={"replace_from"})
        private String replaceFrom;
        @JsonAlias(value={"replace_to"})
        private String replaceTo;
        private final Boolean isRegex = true;

        public String getReplaceFrom() {
            return this.replaceFrom;
        }

        public String getReplaceTo() {
            return this.replaceTo;
        }

        public Boolean getIsRegex() {
            return this.isRegex;
        }

        public ReplacementsWithRegex setReplaceFrom(String replaceFrom) {
            this.replaceFrom = replaceFrom;
            return this;
        }

        public ReplacementsWithRegex setReplaceTo(String replaceTo) {
            this.replaceTo = replaceTo;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReplacementsWithRegex)) {
                return false;
            }
            ReplacementsWithRegex other = (ReplacementsWithRegex)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$isRegex = this.getIsRegex();
            Boolean other$isRegex = other.getIsRegex();
            if (this$isRegex == null ? other$isRegex != null : !((Object)this$isRegex).equals(other$isRegex)) {
                return false;
            }
            String this$replaceFrom = this.getReplaceFrom();
            String other$replaceFrom = other.getReplaceFrom();
            if (this$replaceFrom == null ? other$replaceFrom != null : !this$replaceFrom.equals(other$replaceFrom)) {
                return false;
            }
            String this$replaceTo = this.getReplaceTo();
            String other$replaceTo = other.getReplaceTo();
            return !(this$replaceTo == null ? other$replaceTo != null : !this$replaceTo.equals(other$replaceTo));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ReplacementsWithRegex;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $isRegex = this.getIsRegex();
            result = result * 59 + ($isRegex == null ? 43 : ((Object)$isRegex).hashCode());
            String $replaceFrom = this.getReplaceFrom();
            result = result * 59 + ($replaceFrom == null ? 43 : $replaceFrom.hashCode());
            String $replaceTo = this.getReplaceTo();
            result = result * 59 + ($replaceTo == null ? 43 : $replaceTo.hashCode());
            return result;
        }

        public String toString() {
            return "TableRenameConfig.ReplacementsWithRegex(replaceFrom=" + this.getReplaceFrom() + ", replaceTo=" + this.getReplaceTo() + ", isRegex=" + this.getIsRegex() + ")";
        }

        public ReplacementsWithRegex(String replaceFrom, String replaceTo) {
            this.replaceFrom = replaceFrom;
            this.replaceTo = replaceTo;
        }

        public ReplacementsWithRegex() {
        }
    }
}

