/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.table;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.transform.SeaTunnelTransform;
import org.apache.seatunnel.transform.common.AbstractMultiCatalogMapTransform;
import org.apache.seatunnel.transform.common.AbstractMultiCatalogTransform;
import org.apache.seatunnel.transform.table.TableMergeConfig;
import org.apache.seatunnel.transform.table.TableMergeTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableMergeMultiCatalogTransform
extends AbstractMultiCatalogMapTransform {
    private static final Logger log = LoggerFactory.getLogger(TableMergeMultiCatalogTransform.class);

    public TableMergeMultiCatalogTransform(List<CatalogTable> inputCatalogTables, ReadonlyConfig config) {
        super(inputCatalogTables, config);
    }

    public String getPluginName() {
        return TableMergeTransform.PLUGIN_NAME;
    }

    @Override
    protected SeaTunnelTransform<SeaTunnelRow> buildTransform(CatalogTable table, ReadonlyConfig config) {
        return new TableMergeTransform(TableMergeConfig.of(config), table);
    }

    @Override
    public List<CatalogTable> getProducedCatalogTables() {
        ArrayList<CatalogTable> outputTables = new ArrayList<CatalogTable>();
        LinkedHashMap mergeTables = new LinkedHashMap();
        for (int i = 0; i < this.outputCatalogTables.size(); ++i) {
            CatalogTable inputTable = (CatalogTable)this.inputCatalogTables.get(i);
            CatalogTable outputTable = (CatalogTable)this.outputCatalogTables.get(i);
            String tableId = outputTable.getTablePath().getFullName();
            SeaTunnelTransform transform = (SeaTunnelTransform)this.transformMap.get(tableId);
            if (transform instanceof AbstractMultiCatalogTransform.IdentityTransform) {
                outputTables.add(outputTable);
                continue;
            }
            if (!mergeTables.containsKey(tableId)) {
                mergeTables.put(tableId, new ArrayList());
            }
            ((List)mergeTables.get(tableId)).add(Pair.of((Object)inputTable, (Object)outputTable));
        }
        for (String key : mergeTables.keySet()) {
            List tables = (List)mergeTables.get(key);
            Pair firstTable = (Pair)tables.get(0);
            tables.stream().allMatch(other -> {
                boolean match = ((CatalogTable)firstTable.getRight()).getSeaTunnelRowType().equals((Object)((CatalogTable)other.getRight()).getSeaTunnelRowType());
                if (!match) {
                    throw new UnsupportedOperationException("TableMergeTransform: The schema of the tables to be merged must be the same. The schema of the table " + ((CatalogTable)firstTable.getLeft()).getTablePath().getFullName() + " is different from the schema of the table " + ((CatalogTable)other.getLeft()).getTablePath().getFullName());
                }
                return match;
            });
            outputTables.add((CatalogTable)firstTable.getRight());
        }
        log.info("Input tables: {}", this.inputCatalogTables.stream().map((? super T e) -> e.getTablePath().getFullName()).collect(Collectors.toList()));
        log.info("Output tables: {}", outputTables.stream().map((? super T e) -> e.getTablePath().getFullName()).collect(Collectors.toList()));
        return outputTables;
    }
}

