/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.formatMapper.shapefileParser.shapes;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class ShxFileReader {
    public static int[] readAll(InputSplit split, TaskAttemptContext context) throws IOException {
        FileSplit fileSplit = (FileSplit)split;
        Path inputPath = fileSplit.getPath();
        FileSystem fileSys = inputPath.getFileSystem(context.getConfiguration());
        try (FSDataInputStream stream = fileSys.open(inputPath);){
            int[] nArray = ShxFileReader.readAll((DataInputStream)stream);
            return nArray;
        }
    }

    public static int[] readAll(DataInputStream stream) throws IOException {
        if (stream.skip(24L) != 24L) {
            throw new IOException("Failed to skip 24 bytes in .shx file");
        }
        int shxFileLength = stream.readInt() * 2 - 100;
        if (stream.skip(72L) != 72L) {
            throw new IOException("Failed to skip 72 bytes in .shx file");
        }
        byte[] bytes = new byte[shxFileLength];
        stream.readFully(bytes, 0, bytes.length);
        IntBuffer buffer = ByteBuffer.wrap(bytes).asIntBuffer();
        int[] indexes = new int[shxFileLength / 4];
        buffer.get(indexes);
        return indexes;
    }
}

