/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.stac;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.scala.DefaultScalaModule$;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.execution.datasource.stac.TemporalFilter;
import org.apache.spark.sql.execution.datasources.geoparquet.GeoParquetSpatialFilter;
import org.apache.spark.sql.sedona_sql.io.stac.StacExtension;
import org.apache.spark.sql.sedona_sql.io.stac.StacExtension$;
import org.apache.spark.sql.sedona_sql.io.stac.StacTable$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.locationtech.jts.geom.Envelope;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class StacUtils$ {
    public static StacUtils$ MODULE$;

    static {
        new StacUtils$();
    }

    public String loadStacCollectionToJson(Map<String, String> opts) {
        String urlFull = this.getFullCollectionUrl(opts);
        return this.loadStacCollectionToJson(urlFull, this.loadStacCollectionToJson$default$2());
    }

    /*
     * WARNING - void declaration
     */
    public String getFullCollectionUrl(Map<String, String> opts) {
        void var3_3;
        String url = (String)opts.getOrElse((Object)"path", (Function0 & Serializable & scala.Serializable)() -> (String)opts.getOrElse((Object)"service", (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Either 'path' or 'service' must be provided");
        }));
        String urlFinal = url.matches("^[a-zA-Z][a-zA-Z0-9+.-]*://.*") ? url : new StringBuilder(7).append("file://").append(url).toString();
        return var3_3;
    }

    public String loadStacCollectionToJson(String url, int maxRetries) {
        int retries = 0;
        boolean success = false;
        String result = "";
        while (retries < maxRetries && !success) {
            try {
                result = url.startsWith("s3://") || url.startsWith("s3a://") ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])SparkSession$.MODULE$.active().read().textFile(url).collect())).mkString("\n") : Source$.MODULE$.fromURL(url, Codec$.MODULE$.fallbackSystemCodec()).mkString();
                success = true;
            }
            catch (Exception e) {
                if (++retries < maxRetries) continue;
                throw new RuntimeException(new StringBuilder(52).append("Failed to load STAC collection from ").append(url).append(" after ").append(maxRetries).append(" attempts").toString(), e);
            }
        }
        return result;
    }

    public int loadStacCollectionToJson$default$2() {
        return 3;
    }

    public String getStacCollectionBasePath(Map<String, String> opts) {
        String ref = (String)opts.getOrElse((Object)"path", (Function0 & Serializable & scala.Serializable)() -> (String)opts.getOrElse((Object)"service", (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("Either 'path' or 'service' must be provided");
        }));
        return this.getStacCollectionBasePath(ref);
    }

    public String getStacCollectionBasePath(String collectionUrl) {
        String string;
        Regex urlPattern = new StringOps(Predef$.MODULE$.augmentString("(https?://[^/]+/|http://[^/]+/).*")).r();
        Regex filePattern = new StringOps(Predef$.MODULE$.augmentString("(file:///.*/|/.*/).*")).r();
        String string2 = collectionUrl;
        Option option = urlPattern.unapplySeq((CharSequence)string2);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String baseUrl;
            string = baseUrl = (String)((LinearSeqOptimized)option.get()).apply(0);
        } else {
            Option option2 = filePattern.unapplySeq((CharSequence)string2);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String basePath = (String)((LinearSeqOptimized)option2.get()).apply(0);
                string = basePath.startsWith("file://") ? basePath : new StringBuilder(7).append("file://").append(basePath).toString();
            } else {
                throw new IllegalArgumentException(new StringBuilder(26).append("Invalid URL or file path: ").append(collectionUrl).toString());
            }
        }
        return string;
    }

    public StructType inferStacSchema(Map<String, String> opts) {
        StructType structType;
        String stacVersion;
        String stacCollectionJsonString = this.loadStacCollectionToJson(opts);
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)DefaultScalaModule$.MODULE$);
        JsonNode collection = mapper.readTree(stacCollectionJsonString);
        String string = stacVersion = collection.get("stac_version").asText();
        if ("1.0.0".equals(string)) {
            structType = StacTable$.MODULE$.SCHEMA_V1_0_0();
        } else if (string.matches("1\\.[1-9]\\d*\\.\\d*")) {
            structType = StacTable$.MODULE$.SCHEMA_V1_1_0();
        } else {
            throw new IllegalArgumentException(new StringBuilder(26).append("Unsupported STAC version: ").append(stacVersion).toString());
        }
        StructType coreSchema = structType;
        StacExtension[] extensions = StacExtension$.MODULE$.getStacExtensionDefinitions();
        StructType schemaWithExtensions = this.addExtensionFieldsToSchema(coreSchema, extensions);
        return schemaWithExtensions;
    }

    public StructType addExtensionFieldsToSchema(StructType schema, StacExtension[] extensions) {
        Option propertiesFieldOpt = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StacUtils$.$anonfun$addExtensionFieldsToSchema$1(x$1)));
        if (propertiesFieldOpt.isEmpty()) {
            return schema;
        }
        StructField propertiesField = (StructField)propertiesFieldOpt.get();
        StructType propertiesStruct = (StructType)propertiesField.dataType();
        StructField[] extensionFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])extensions)).flatMap((Function1 & Serializable & scala.Serializable)extension -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])extension.schema().fields())).map((Function1 & Serializable & scala.Serializable)field -> new StructField(field.name(), field.dataType(), field.nullable(), new MetadataBuilder().withMetadata(field.metadata()).putString("stac_extension", extension.name()).build()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        StructType updatedPropertiesStruct = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])propertiesStruct.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])extensionFields)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        StructField updatedPropertiesField = new StructField(propertiesField.name(), (DataType)updatedPropertiesStruct, propertiesField.nullable(), propertiesField.metadata());
        StructField[] updatedFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            StructField structField = x0$1;
            String string = structField.name();
            String string2 = "properties";
            StructField structField2 = !(string != null ? !string.equals(string2) : string2 != null) ? updatedPropertiesField : structField;
            return structField2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        return new StructType(updatedFields);
    }

    public InternalRow promotePropertiesToTop(InternalRow row, StructType schema) {
        int propertiesIndex = schema.fieldIndex("properties");
        StructType propertiesStruct = (StructType)schema.apply("properties").dataType();
        InternalRow propertiesRow = row.getStruct(propertiesIndex, propertiesStruct.fields().length);
        Seq newValues = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                Seq acc = (Seq)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    StructField field = (StructField)tuple22._1();
                    String string = field.name();
                    String string2 = "properties";
                    if (string == null) {
                        if (string2 == null) return (Seq)acc.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])propertiesStruct.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            StructField propField = (StructField)tuple2._1();
                            int propIndex = tuple2._2$mcI$sp();
                            Object object = propertiesRow.get(propIndex, propField.dataType());
                            return object;
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object())))), Seq$.MODULE$.canBuildFrom());
                    } else if (string.equals(string2)) {
                        return (Seq)acc.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])propertiesStruct.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            StructField propField = (StructField)tuple2._1();
                            int propIndex = tuple2._2$mcI$sp();
                            Object object = propertiesRow.get(propIndex, propField.dataType());
                            return object;
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Object())))), Seq$.MODULE$.canBuildFrom());
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Seq acc = (Seq)tuple2._1();
            Tuple2 tuple23 = (Tuple2)tuple2._2();
            if (tuple23 == null) throw new MatchError((Object)tuple2);
            int index = tuple23._2$mcI$sp();
            return (Seq)acc.$colon$plus(row.get(index, schema.apply(index).dataType()), Seq$.MODULE$.canBuildFrom());
        });
        return InternalRow$.MODULE$.fromSeq(newValues);
    }

    public StructType updatePropertiesPromotedSchema(StructType schema) {
        int propertiesIndex = schema.fieldIndex("properties");
        StructType propertiesStruct = (StructType)schema.apply("properties").dataType();
        Seq newFields = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                String string;
                Seq acc = (Seq)tuple2._1();
                StructField structField = (StructField)tuple2._2();
                if (structField != null && "properties".equals(string = structField.name())) {
                    return (Seq)acc.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])propertiesStruct.fields())), Seq$.MODULE$.canBuildFrom());
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Seq acc = (Seq)tuple2._1();
            StructField other = (StructField)tuple2._2();
            return (Seq)acc.$colon$plus((Object)other, Seq$.MODULE$.canBuildFrom());
        });
        return StructType$.MODULE$.apply(newFields);
    }

    public int getNumPartitions(int itemCount, int numPartitions, int maxPartitionItemFiles, int defaultParallelism) {
        int n;
        if (numPartitions > 0) {
            n = numPartitions;
        } else {
            int maxSplitFiles = maxPartitionItemFiles > 0 ? Math.min(maxPartitionItemFiles, (int)Math.ceil((double)itemCount / (double)defaultParallelism)) : (int)Math.ceil((double)itemCount / (double)defaultParallelism);
            n = Math.max(1, (int)Math.ceil((double)itemCount / (double)maxSplitFiles));
        }
        return n;
    }

    public String getFilterBBox(GeoParquetSpatialFilter filter) {
        Envelope unionEnvelope = StacUtils$.calculateUnionBBox$1(filter);
        return new StringBuilder(14).append("bbox=").append(unionEnvelope.getMinX()).append("%2C").append(unionEnvelope.getMinY()).append("%2C").append(unionEnvelope.getMaxX()).append("%2C").append(unionEnvelope.getMaxY()).toString();
    }

    public String getFilterTemporal(TemporalFilter filter) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        Tuple2 tuple2 = StacUtils$.calculateUnionTemporal$1(filter);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        LocalDateTime start = (LocalDateTime)tuple2._1();
        LocalDateTime end = (LocalDateTime)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)start, (Object)end);
        Tuple2 tuple23 = tuple22;
        LocalDateTime start2 = (LocalDateTime)tuple23._1();
        LocalDateTime end2 = (LocalDateTime)tuple23._2();
        return end2 == null ? new StringBuilder(12).append("datetime=").append(StacUtils$.formatDateTime$1(start2, formatter)).append("/..").toString() : new StringBuilder(10).append("datetime=").append(StacUtils$.formatDateTime$1(start2, formatter)).append("/").append(StacUtils$.formatDateTime$1(end2, formatter)).toString();
    }

    public String addFiltersToUrl(String baseUrl, Option<GeoParquetSpatialFilter> spatialFilter, Option<TemporalFilter> temporalFilter) {
        String temporalFilterStr;
        String spatialFilterStr = (String)spatialFilter.map((Function1 & Serializable & scala.Serializable)filter -> MODULE$.getFilterBBox((GeoParquetSpatialFilter)filter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String filters = ((TraversableOnce)((TraversableLike)new .colon.colon((Object)spatialFilterStr, (List)new .colon.colon((Object)(temporalFilterStr = (String)temporalFilter.map((Function1 & Serializable & scala.Serializable)filter -> MODULE$.getFilterTemporal((TemporalFilter)filter)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (List)Nil$.MODULE$))).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)StacUtils$.$anonfun$addFiltersToUrl$5(x$7)))).mkString("&");
        String urlWithFilters = new StringOps(Predef$.MODULE$.augmentString(filters)).nonEmpty() ? new StringBuilder(1).append("&").append(filters).toString() : "";
        return new StringBuilder(0).append(baseUrl).append(urlWithFilters).toString();
    }

    public static final /* synthetic */ boolean $anonfun$addExtensionFieldsToSchema$1(StructField x$1) {
        String string = x$1.name();
        String string2 = "properties";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private static final Envelope calculateUnionBBox$1(GeoParquetSpatialFilter filter) {
        Envelope envelope;
        GeoParquetSpatialFilter geoParquetSpatialFilter = filter;
        if (geoParquetSpatialFilter instanceof GeoParquetSpatialFilter.AndFilter) {
            GeoParquetSpatialFilter.AndFilter andFilter = (GeoParquetSpatialFilter.AndFilter)geoParquetSpatialFilter;
            GeoParquetSpatialFilter left = andFilter.left();
            GeoParquetSpatialFilter right = andFilter.right();
            Envelope leftEnvelope = StacUtils$.calculateUnionBBox$1(left);
            Envelope rightEnvelope = StacUtils$.calculateUnionBBox$1(right);
            leftEnvelope.expandToInclude(rightEnvelope);
            envelope = leftEnvelope;
        } else if (geoParquetSpatialFilter instanceof GeoParquetSpatialFilter.OrFilter) {
            GeoParquetSpatialFilter.OrFilter orFilter = (GeoParquetSpatialFilter.OrFilter)geoParquetSpatialFilter;
            GeoParquetSpatialFilter left = orFilter.left();
            GeoParquetSpatialFilter right = orFilter.right();
            Envelope leftEnvelope = StacUtils$.calculateUnionBBox$1(left);
            Envelope rightEnvelope = StacUtils$.calculateUnionBBox$1(right);
            leftEnvelope.expandToInclude(rightEnvelope);
            envelope = leftEnvelope;
        } else if (geoParquetSpatialFilter instanceof GeoParquetSpatialFilter.LeafFilter) {
            GeoParquetSpatialFilter.LeafFilter leafFilter = (GeoParquetSpatialFilter.LeafFilter)geoParquetSpatialFilter;
            envelope = leafFilter.queryWindow().getEnvelopeInternal();
        } else {
            throw new MatchError((Object)geoParquetSpatialFilter);
        }
        return envelope;
    }

    private static final String formatDateTime$1(LocalDateTime dateTime, DateTimeFormatter formatter$1) {
        return dateTime == null ? ".." : dateTime.format(formatter$1);
    }

    private static final Tuple2 calculateUnionTemporal$1(TemporalFilter filter) {
        Tuple2 tuple2;
        TemporalFilter temporalFilter = filter;
        if (temporalFilter instanceof TemporalFilter.AndFilter) {
            TemporalFilter.AndFilter andFilter = (TemporalFilter.AndFilter)temporalFilter;
            TemporalFilter left = andFilter.left();
            TemporalFilter right = andFilter.right();
            Tuple2 tuple22 = StacUtils$.calculateUnionTemporal$1(left);
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            LocalDateTime leftStart = (LocalDateTime)tuple22._1();
            LocalDateTime leftEnd = (LocalDateTime)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)leftStart, (Object)leftEnd);
            Tuple2 tuple24 = tuple23;
            LocalDateTime leftStart2 = (LocalDateTime)tuple24._1();
            LocalDateTime leftEnd2 = (LocalDateTime)tuple24._2();
            Tuple2 tuple25 = StacUtils$.calculateUnionTemporal$1(right);
            if (tuple25 == null) {
                throw new MatchError((Object)tuple25);
            }
            LocalDateTime rightStart = (LocalDateTime)tuple25._1();
            LocalDateTime rightEnd = (LocalDateTime)tuple25._2();
            Tuple2 tuple26 = new Tuple2((Object)rightStart, (Object)rightEnd);
            Tuple2 tuple27 = tuple26;
            LocalDateTime rightStart2 = (LocalDateTime)tuple27._1();
            LocalDateTime rightEnd2 = (LocalDateTime)tuple27._2();
            LocalDateTime start = leftStart2 == null || rightStart2 != null && rightStart2.isBefore(leftStart2) ? rightStart2 : leftStart2;
            LocalDateTime end = leftEnd2 == null || rightEnd2 != null && rightEnd2.isAfter(leftEnd2) ? rightEnd2 : leftEnd2;
            tuple2 = new Tuple2((Object)start, (Object)end);
        } else if (temporalFilter instanceof TemporalFilter.OrFilter) {
            TemporalFilter.OrFilter orFilter = (TemporalFilter.OrFilter)temporalFilter;
            TemporalFilter left = orFilter.left();
            TemporalFilter right = orFilter.right();
            Tuple2 tuple28 = StacUtils$.calculateUnionTemporal$1(left);
            if (tuple28 == null) {
                throw new MatchError((Object)tuple28);
            }
            LocalDateTime leftStart = (LocalDateTime)tuple28._1();
            LocalDateTime leftEnd = (LocalDateTime)tuple28._2();
            Tuple2 tuple29 = new Tuple2((Object)leftStart, (Object)leftEnd);
            Tuple2 tuple210 = tuple29;
            LocalDateTime leftStart3 = (LocalDateTime)tuple210._1();
            LocalDateTime leftEnd3 = (LocalDateTime)tuple210._2();
            Tuple2 tuple211 = StacUtils$.calculateUnionTemporal$1(right);
            if (tuple211 == null) {
                throw new MatchError((Object)tuple211);
            }
            LocalDateTime rightStart = (LocalDateTime)tuple211._1();
            LocalDateTime rightEnd = (LocalDateTime)tuple211._2();
            Tuple2 tuple212 = new Tuple2((Object)rightStart, (Object)rightEnd);
            Tuple2 tuple213 = tuple212;
            LocalDateTime rightStart3 = (LocalDateTime)tuple213._1();
            LocalDateTime rightEnd3 = (LocalDateTime)tuple213._2();
            LocalDateTime start = leftStart3 == null || rightStart3 != null && rightStart3.isBefore(leftStart3) ? rightStart3 : leftStart3;
            LocalDateTime end = leftEnd3 == null || rightEnd3 != null && rightEnd3.isAfter(leftEnd3) ? rightEnd3 : leftEnd3;
            tuple2 = new Tuple2((Object)start, (Object)end);
        } else if (temporalFilter instanceof TemporalFilter.LessThanFilter) {
            TemporalFilter.LessThanFilter lessThanFilter = (TemporalFilter.LessThanFilter)temporalFilter;
            LocalDateTime value = lessThanFilter.value();
            tuple2 = new Tuple2(null, (Object)value);
        } else if (temporalFilter instanceof TemporalFilter.GreaterThanFilter) {
            TemporalFilter.GreaterThanFilter greaterThanFilter = (TemporalFilter.GreaterThanFilter)temporalFilter;
            LocalDateTime value = greaterThanFilter.value();
            tuple2 = new Tuple2((Object)value, null);
        } else if (temporalFilter instanceof TemporalFilter.EqualFilter) {
            TemporalFilter.EqualFilter equalFilter = (TemporalFilter.EqualFilter)temporalFilter;
            LocalDateTime value = equalFilter.value();
            tuple2 = new Tuple2((Object)value, (Object)value);
        } else {
            throw new MatchError((Object)temporalFilter);
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$addFiltersToUrl$5(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).nonEmpty();
    }

    private StacUtils$() {
        MODULE$ = this;
    }
}

