/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.highway;

import io.vertx.core.buffer.Buffer;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.servicecomb.codec.protobuf.definition.OperationProtobuf;
import org.apache.servicecomb.codec.protobuf.definition.ResponseRootSerializer;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProducerFilter;
import org.apache.servicecomb.foundation.common.utils.AsyncUtils;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.transport.highway.HighwayCodec;
import org.apache.servicecomb.transport.highway.HighwayTransportContext;
import org.apache.servicecomb.transport.highway.message.ResponseHeader;
import org.springframework.stereotype.Component;

@Component
public class HighwayServerCodecFilter
implements ProducerFilter {
    public static final String NAME = "highway-server-codec";

    @Nonnull
    public String getName() {
        return NAME;
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(invocation).thenCompose(this::decodeRequest)).thenCompose(arg_0 -> ((FilterNode)nextNode).onFilter(arg_0))).exceptionally(exception -> Exceptions.toProducerResponse((Invocation)invocation, (Throwable)exception))).thenCompose(response -> this.encodeResponse(invocation, (Response)response));
    }

    protected CompletableFuture<Invocation> decodeRequest(Invocation invocation) {
        HighwayTransportContext transportContext = (HighwayTransportContext)invocation.getTransportContext();
        try {
            HighwayCodec.decodeRequest(invocation, transportContext.getHeader(), transportContext.getOperationProtobuf(), transportContext.getBodyBuffer());
            return CompletableFuture.completedFuture(invocation);
        }
        catch (Exception e) {
            return AsyncUtils.completeExceptionally((Throwable)e);
        }
    }

    protected CompletableFuture<Response> encodeResponse(Invocation invocation, Response response) {
        invocation.onEncodeResponseStart(response);
        ResponseHeader header = new ResponseHeader();
        header.setStatusCode(response.getStatusCode());
        header.setReasonPhrase(response.getReasonPhrase());
        header.setContext(invocation.getContext());
        header.fromMultiMap(response.getHeaders());
        HighwayTransportContext transportContext = (HighwayTransportContext)invocation.getTransportContext();
        long msgId = transportContext.getMsgId();
        OperationProtobuf operationProtobuf = transportContext.getOperationProtobuf();
        ResponseRootSerializer bodySchema = operationProtobuf.findResponseRootSerializer(response.getStatusCode());
        try {
            Buffer respBuffer = HighwayCodec.encodeResponse(msgId, header, bodySchema, response.getResult());
            transportContext.setResponseBuffer(respBuffer);
            return CompletableFuture.completedFuture(response);
        }
        catch (Exception e) {
            String msg = String.format("encode response failed, msgId=%d", msgId);
            return AsyncUtils.completeExceptionally((Throwable)new IllegalStateException(msg, e));
        }
    }
}

