/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.AbstractPollingScheduler;
import com.netflix.config.PolledConfigurationSource;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;

public class ConfigurationWithPollingSource
implements Configuration {
    private final Configuration config;
    private final AbstractPollingScheduler scheduler;

    public ConfigurationWithPollingSource(Configuration config, PolledConfigurationSource source, AbstractPollingScheduler scheduler) {
        this.config = config;
        this.scheduler = scheduler;
        scheduler.startPolling(source, this);
    }

    public final Configuration getConfiguration() {
        return this.config;
    }

    public final void stopPolling() {
        this.scheduler.stop();
    }

    public void addProperty(String key, Object value) {
        this.config.addProperty(key, value);
    }

    public void clear() {
        this.config.clear();
    }

    public void clearProperty(String key) {
        this.config.clearProperty(key);
    }

    public boolean containsKey(String arg0) {
        return this.config.containsKey(arg0);
    }

    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        return this.config.getBigDecimal(key, defaultValue);
    }

    public BigDecimal getBigDecimal(String key) {
        return this.config.getBigDecimal(key);
    }

    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        return this.config.getBigInteger(key, defaultValue);
    }

    public BigInteger getBigInteger(String key) {
        return this.config.getBigInteger(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.config.getBoolean(key, defaultValue);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        return this.config.getBoolean(key, defaultValue);
    }

    public boolean getBoolean(String key) {
        return this.config.getBoolean(key);
    }

    public byte getByte(String key, byte defaultValue) {
        return this.config.getByte(key, defaultValue);
    }

    public Byte getByte(String key, Byte defaultValue) {
        return this.config.getByte(key, defaultValue);
    }

    public byte getByte(String key) {
        return this.config.getByte(key);
    }

    public double getDouble(String key, double defaultValue) {
        return this.config.getDouble(key, defaultValue);
    }

    public Double getDouble(String key, Double defaultValue) {
        return this.config.getDouble(key, defaultValue);
    }

    public double getDouble(String key) {
        return this.config.getDouble(key);
    }

    public float getFloat(String key, float defaultValue) {
        return this.config.getFloat(key, defaultValue);
    }

    public Float getFloat(String key, Float defaultValue) {
        return this.config.getFloat(key, defaultValue);
    }

    public float getFloat(String key) {
        return this.config.getFloat(key);
    }

    public int getInt(String key, int defaultValue) {
        return this.config.getInt(key, defaultValue);
    }

    public int getInt(String key) {
        return this.config.getInt(key);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        return this.config.getInteger(key, defaultValue);
    }

    public Iterator getKeys() {
        return this.config.getKeys();
    }

    public Iterator getKeys(String prefix) {
        return this.config.getKeys(prefix);
    }

    public List getList(String key, List defaultValue) {
        return this.config.getList(key, defaultValue);
    }

    public List getList(String key) {
        return this.config.getList(key);
    }

    public long getLong(String key, long defaultValue) {
        return this.config.getLong(key, defaultValue);
    }

    public Long getLong(String key, Long defaultValue) {
        return this.config.getLong(key, defaultValue);
    }

    public long getLong(String key) {
        return this.config.getLong(key);
    }

    public Properties getProperties(String key) {
        return this.config.getProperties(key);
    }

    public Object getProperty(String arg0) {
        return this.config.getProperty(arg0);
    }

    public short getShort(String key, short defaultValue) {
        return this.config.getShort(key, defaultValue);
    }

    public Short getShort(String key, Short defaultValue) {
        return this.config.getShort(key, defaultValue);
    }

    public short getShort(String key) {
        return this.config.getShort(key);
    }

    public String getString(String key, String defaultValue) {
        return this.config.getString(key, defaultValue);
    }

    public String getString(String key) {
        return this.config.getString(key);
    }

    public String[] getStringArray(String key) {
        return this.config.getStringArray(key);
    }

    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    public void setProperty(String key, Object value) {
        this.config.setProperty(key, value);
    }

    public Configuration subset(String prefix) {
        return this.config.subset(prefix);
    }
}

