/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.core.register.extractor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shenyu.client.core.register.ApiBean;
import org.apache.shenyu.client.core.register.extractor.RpcApiBeansExtractor;
import org.apache.shenyu.client.core.register.matcher.ExtractorProcessor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;

public abstract class BaseApiBeansExtractor
implements RpcApiBeansExtractor {
    protected static final Logger LOG = LoggerFactory.getLogger(BaseApiBeansExtractor.class);
    private final List<ExtractorProcessor> extractorProcessors = new ArrayList<ExtractorProcessor>(5);

    @Override
    public List<ApiBean> extract(ApplicationContext applicationContext) {
        Map<String, Object> supportBeans = this.extractSupportBeans(applicationContext);
        if (Objects.isNull(supportBeans)) {
            return Collections.emptyList();
        }
        return this.extract(applicationContext, supportBeans);
    }

    @NotNull
    public List<ApiBean> extract(ApplicationContext applicationContext, Map<String, Object> supportBeans) {
        return supportBeans.entrySet().stream().map(entity -> this.beanToApi((String)entity.getKey(), entity.getValue(), applicationContext)).filter(this::apiPostFilter).peek(this::apiPostProcess).collect(Collectors.toList());
    }

    protected boolean apiPostFilter(ApiBean api) {
        return Objects.nonNull(api);
    }

    protected void apiPostProcess(ApiBean api) {
        this.extractorProcessors.forEach(apiAnnotationProcessor -> apiAnnotationProcessor.process(api));
        LOG.debug("[Shenyu Client] extract api info [{}]", (Object)api);
    }

    protected ApiBean beanToApi(String key, Object value, ApplicationContext applicationContext) {
        List<ApiBean.ApiDefinition> apiDefinitions = this.extractSupportDefinitions(value, applicationContext);
        if (CollectionUtils.isEmpty(apiDefinitions)) {
            return null;
        }
        return this.newApi(key, value, apiDefinitions);
    }

    protected ApiBean newApi(String key, Object value, List<ApiBean.ApiDefinition> apiDefinitions) {
        return new ApiBean(this.clientName(), key, value, apiDefinitions);
    }

    protected List<ApiBean.ApiDefinition> extractSupportDefinitions(Object bean, ApplicationContext applicationContext) {
        return this.extractSupportMethods(bean, applicationContext).stream().map(method -> this.newApiDefinition((Method)method, applicationContext)).filter(this::definitionPostFilter).peek(this::definitionPostProcess).collect(Collectors.toList());
    }

    protected void definitionPostProcess(ApiBean.ApiDefinition apiDefinition) {
        this.extractorProcessors.forEach(apiAnnotationProcessor -> apiAnnotationProcessor.process(apiDefinition));
        LOG.debug("[Shenyu Client] extract api definition info [{}]", (Object)apiDefinition);
    }

    protected boolean definitionPostFilter(ApiBean.ApiDefinition apiDefinition) {
        return Objects.nonNull(apiDefinition);
    }

    protected ApiBean.ApiDefinition newApiDefinition(Method method, ApplicationContext applicationContext) {
        return new ApiBean.ApiDefinition(method);
    }

    protected List<Method> extractSupportMethods(Object bean, ApplicationContext applicationContext) {
        return Arrays.stream(ReflectionUtils.getUniqueDeclaredMethods(bean.getClass())).collect(Collectors.toList());
    }

    public void addExtractorProcessor(ExtractorProcessor processor) {
        if (CollectionUtils.isEmpty(processor.supportedClient())) {
            return;
        }
        if (processor.supportedClient().contains(this.clientName())) {
            this.extractorProcessors.add(processor);
        }
    }

    protected abstract Map<String, Object> extractSupportBeans(ApplicationContext var1);
}

