/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto.convert.rule;

import java.util.Objects;
import org.apache.shenyu.common.enums.AiModelProviderEnum;

public class AiProxyHandle {
    private String provider;
    private String baseUrl;
    private String apiKey;
    private String model;
    private Double temperature = 0.8;
    private Integer maxTokens;
    private Boolean stream = false;
    private FallbackConfig fallbackConfig;
    private String fallbackEnabled;
    private String fallbackProvider;
    private String fallbackBaseUrl;
    private String fallbackApiKey;
    private String fallbackModel;
    private Double fallbackTemperature;
    private Integer fallbackMaxTokens;
    private String proxyEnabled;

    public static AiProxyHandle newDefaultInstance() {
        AiProxyHandle aiProxyHandle = new AiProxyHandle();
        aiProxyHandle.setProvider(AiModelProviderEnum.OPEN_AI.getName());
        aiProxyHandle.setBaseUrl("https://api.openai.com");
        aiProxyHandle.setApiKey("your-api-key");
        aiProxyHandle.setModel("gpt-4o-mini");
        aiProxyHandle.setTemperature(0.8);
        aiProxyHandle.setStream(false);
        aiProxyHandle.setFallbackConfig(new FallbackConfig());
        return aiProxyHandle;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Double temperature) {
        this.temperature = temperature;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public void setMaxTokens(Integer maxTokens) {
        this.maxTokens = maxTokens;
    }

    public Boolean getStream() {
        return this.stream;
    }

    public void setStream(Boolean stream) {
        this.stream = stream;
    }

    public FallbackConfig getFallbackConfig() {
        return this.fallbackConfig;
    }

    public void setFallbackConfig(FallbackConfig fallbackConfig) {
        this.fallbackConfig = fallbackConfig;
    }

    public AiProxyHandle normalize() {
        FallbackConfig cfg;
        boolean enabled = "true".equalsIgnoreCase(String.valueOf(this.fallbackEnabled));
        if (!enabled) {
            this.fallbackConfig = null;
            return this;
        }
        FallbackConfig fallbackConfig = cfg = Objects.nonNull(this.fallbackConfig) ? this.fallbackConfig : new FallbackConfig();
        if (Objects.nonNull(this.fallbackProvider) && !this.fallbackProvider.isEmpty()) {
            cfg.setProvider(this.fallbackProvider);
        }
        if (Objects.nonNull(this.fallbackBaseUrl) && !this.fallbackBaseUrl.isEmpty()) {
            cfg.setBaseUrl(this.fallbackBaseUrl);
        }
        if (Objects.nonNull(this.fallbackApiKey) && !this.fallbackApiKey.isEmpty()) {
            cfg.setApiKey(this.fallbackApiKey);
        }
        if (Objects.nonNull(this.fallbackModel) && !this.fallbackModel.isEmpty()) {
            cfg.setModel(this.fallbackModel);
        }
        if (Objects.nonNull(this.fallbackTemperature)) {
            cfg.setTemperature(this.fallbackTemperature);
        }
        if (Objects.nonNull(this.fallbackMaxTokens)) {
            cfg.setMaxTokens(this.fallbackMaxTokens);
        }
        this.fallbackConfig = cfg;
        return this;
    }

    public String getProxyEnabled() {
        return this.proxyEnabled;
    }

    public void setProxyEnabled(String proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        AiProxyHandle that = (AiProxyHandle)o;
        return Objects.equals(this.provider, that.provider) && Objects.equals(this.baseUrl, that.baseUrl) && Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.model, that.model) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.maxTokens, that.maxTokens) && Objects.equals(this.stream, that.stream) && Objects.equals(this.fallbackConfig, that.fallbackConfig) && Objects.equals(this.proxyEnabled, that.proxyEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.provider, this.baseUrl, this.apiKey, this.model, this.temperature, this.maxTokens, this.stream, this.fallbackConfig, this.proxyEnabled);
    }

    public String toString() {
        return "AiProxyHandle{provider='" + this.provider + "', baseUrl='" + this.baseUrl + "', apiKey='" + AiProxyHandle.maskApiKey(this.apiKey) + "', model='" + this.model + "', temperature=" + this.temperature + ", maxTokens=" + this.maxTokens + ", stream=" + this.stream + ", fallbackConfig=" + this.fallbackConfig + ", proxyEnabled=" + this.proxyEnabled + "}";
    }

    public static String maskApiKey(String apiKey) {
        if (Objects.isNull(apiKey) || apiKey.isEmpty()) {
            return apiKey;
        }
        int len = apiKey.length();
        if (len <= 4) {
            return apiKey.substring(0, 1) + "***";
        }
        if (len <= 7) {
            return apiKey.substring(0, 1) + "***" + apiKey.substring(len - 1);
        }
        return apiKey.substring(0, 3) + "****" + apiKey.substring(len - 4);
    }

    public static class FallbackConfig {
        private String provider;
        private String baseUrl;
        private String apiKey;
        private String model;
        private Double temperature;
        private Integer maxTokens;

        public String getProvider() {
            return this.provider;
        }

        public void setProvider(String provider) {
            this.provider = provider;
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public String getApiKey() {
            return this.apiKey;
        }

        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public Double getTemperature() {
            return this.temperature;
        }

        public void setTemperature(Double temperature) {
            this.temperature = temperature;
        }

        public Integer getMaxTokens() {
            return this.maxTokens;
        }

        public void setMaxTokens(Integer maxTokens) {
            this.maxTokens = maxTokens;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (Objects.isNull(o) || this.getClass() != o.getClass()) {
                return false;
            }
            FallbackConfig that = (FallbackConfig)o;
            return Objects.equals(this.provider, that.provider) && Objects.equals(this.baseUrl, that.baseUrl) && Objects.equals(this.apiKey, that.apiKey) && Objects.equals(this.model, that.model) && Objects.equals(this.temperature, that.temperature) && Objects.equals(this.maxTokens, that.maxTokens);
        }

        public int hashCode() {
            return Objects.hash(this.provider, this.baseUrl, this.apiKey, this.model, this.temperature, this.maxTokens);
        }

        public String toString() {
            return "FallbackConfig{provider='" + this.provider + "', baseUrl='" + this.baseUrl + "', apiKey='" + AiProxyHandle.maskApiKey(this.apiKey) + "', model='" + this.model + "', temperature=" + this.temperature + ", maxTokens=" + this.maxTokens + "}";
        }
    }
}

