/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.jdbc;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.integration.jdbc.SqlParameterSourceFactory;
import org.springframework.integration.util.AbstractExpressionEvaluator;
import org.springframework.jdbc.core.namedparam.AbstractSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ExpressionEvaluatingSqlParameterSourceFactory
extends AbstractExpressionEvaluator
implements SqlParameterSourceFactory {
    private static final Object ERROR = new Object();
    private final Map<String, Object> staticParameters = new HashMap<String, Object>();
    private final Map<String, Integer> sqlParametersTypes = new HashMap<String, Integer>();
    private final Map<String, Expression[]> parameterExpressions = new HashMap<String, Expression[]>();

    public void setStaticParameters(Map<String, Object> staticParameters) {
        Assert.notNull(staticParameters, (String)"'staticParameters' must not be null");
        this.staticParameters.putAll(staticParameters);
    }

    public void setParameterExpressions(Map<String, String> parameterExpressions) {
        Assert.notNull(parameterExpressions, (String)"'parameterExpressions' must not be null");
        HashMap<String, Expression[]> paramExpressions = new HashMap<String, Expression[]>(parameterExpressions.size());
        for (Map.Entry<String, String> entry : parameterExpressions.entrySet()) {
            String key = entry.getKey();
            String expression = entry.getValue();
            Expression[] expressions = new Expression[]{EXPRESSION_PARSER.parseExpression(expression), EXPRESSION_PARSER.parseExpression("#root.![" + expression + "]")};
            paramExpressions.put(key, expressions);
        }
        this.parameterExpressions.putAll(paramExpressions);
    }

    public void setSqlParameterTypes(Map<String, Integer> sqlParametersTypes) {
        Assert.notNull(sqlParametersTypes, (String)"'sqlParametersTypes' must not be null");
        this.sqlParametersTypes.putAll(sqlParametersTypes);
    }

    @Override
    public SqlParameterSource createParameterSource(Object input) {
        return new ExpressionEvaluatingSqlParameterSource(input, this.staticParameters, this.parameterExpressions, true);
    }

    public SqlParameterSource createParameterSourceNoCache(Object input) {
        return new ExpressionEvaluatingSqlParameterSource(input, this.staticParameters, this.parameterExpressions, false);
    }

    protected void onInit() {
        this.getEvaluationContext().setVariable("staticParameters", this.staticParameters);
    }

    private final class ExpressionEvaluatingSqlParameterSource
    extends AbstractSqlParameterSource {
        private final Object input;
        private final Map<String, Object> values = new HashMap<String, Object>();
        private final Map<String, Expression[]> parameterExpressions;
        private final boolean cache;

        ExpressionEvaluatingSqlParameterSource(Object input, Map<String, ?> staticParameters, Map<String, Expression[]> parameterExpressions, boolean cache) {
            this.input = input;
            this.parameterExpressions = parameterExpressions;
            this.values.putAll(staticParameters);
            this.cache = cache;
            if (ExpressionEvaluatingSqlParameterSourceFactory.this.sqlParametersTypes != null) {
                ExpressionEvaluatingSqlParameterSourceFactory.this.sqlParametersTypes.forEach((arg_0, arg_1) -> ((ExpressionEvaluatingSqlParameterSource)this).registerSqlType(arg_0, arg_1));
            }
        }

        @Nullable
        public Object getValue(String paramName) throws IllegalArgumentException {
            return this.doGetValue(paramName, false);
        }

        @Nullable
        public Object doGetValue(String paramName, boolean calledFromHasValue) throws IllegalArgumentException {
            if (this.values.containsKey(paramName)) {
                Object cachedByHasValue = this.values.get(paramName);
                if (!this.cache) {
                    this.values.remove(paramName);
                }
                return cachedByHasValue;
            }
            if (!this.parameterExpressions.containsKey(paramName)) {
                Expression[] expressions = new Expression[]{EXPRESSION_PARSER.parseExpression(paramName), EXPRESSION_PARSER.parseExpression("#root.![" + paramName + "]")};
                ExpressionEvaluatingSqlParameterSourceFactory.this.parameterExpressions.put(paramName, expressions);
                this.parameterExpressions.put(paramName, expressions);
            }
            Expression expression = this.input instanceof Collection ? this.parameterExpressions.get(paramName)[1] : this.parameterExpressions.get(paramName)[0];
            Object value = ExpressionEvaluatingSqlParameterSourceFactory.this.evaluateExpression(expression, this.input);
            if (this.cache || calledFromHasValue) {
                this.values.put(paramName, value);
            }
            ExpressionEvaluatingSqlParameterSourceFactory.this.logger.debug(() -> "Resolved expression " + expression + " to " + value);
            return value;
        }

        public boolean hasValue(String paramName) {
            try {
                Object value = this.doGetValue(paramName, true);
                if (ERROR.equals(value)) {
                    return false;
                }
            }
            catch (ExpressionException ex) {
                ExpressionEvaluatingSqlParameterSourceFactory.this.logger.debug((Throwable)ex, (CharSequence)"Could not evaluate expression");
                if (this.cache) {
                    this.values.put(paramName, ERROR);
                }
                return false;
            }
            return true;
        }
    }
}

