/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.publish;

import java.util.Collection;
import org.apache.shenyu.admin.model.entity.ShenyuDictDO;
import org.apache.shenyu.admin.model.event.AdminDataModelChangedEvent;
import org.apache.shenyu.admin.model.event.dict.BatchDictDeletedEvent;
import org.apache.shenyu.admin.model.event.dict.DictCreatedEvent;
import org.apache.shenyu.admin.model.event.dict.DictUpdatedEvent;
import org.apache.shenyu.admin.service.publish.AdminDataModelChangedEventPublisher;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
public class DictEventPublisher
implements AdminDataModelChangedEventPublisher<ShenyuDictDO> {
    private final ApplicationEventPublisher publisher;

    public DictEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public void onCreated(ShenyuDictDO data) {
        this.publish(new DictCreatedEvent(data, SessionUtil.visitorName()));
    }

    @Override
    public void onUpdated(ShenyuDictDO selector, ShenyuDictDO before) {
        this.publish(new DictUpdatedEvent(selector, before, SessionUtil.visitorName()));
    }

    @Override
    public void onDeleted(Collection<ShenyuDictDO> dict) {
        this.publish(new BatchDictDeletedEvent(dict, SessionUtil.visitorName()));
    }

    @Override
    public void publish(AdminDataModelChangedEvent event) {
        this.publisher.publishEvent((ApplicationEvent)event);
    }
}

