/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrProperty;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class MVPEditor
extends Dialog {
    private final JcrProperty property;
    private List<Line> lines = new ArrayList<Line>();
    private TableViewer viewer;
    private final Color greyColor;

    protected MVPEditor(Shell parentShell, JcrProperty property) {
        super(parentShell);
        this.property = property;
        if (!property.isMultiple()) {
            throw new IllegalArgumentException("Property " + property.getName() + " is not a Multi-Value Property");
        }
        this.greyColor = new Color((Device)parentShell.getDisplay(), 100, 100, 100);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Modify multi value property");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite header = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.numColumns = 3;
        header.setLayout((Layout)layout);
        Label label = new Label(header, 64);
        label.setText("Modify property " + this.property.getName() + ":");
        GridData data = new GridData(1796);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        label.setLayoutData((Object)data);
        label.setFont(parent.getFont());
        ToolBar buttonBar = new ToolBar(header, 0);
        new ToolItem(buttonBar, 0);
        ToolItem plus = new ToolItem(buttonBar, 0);
        plus.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD").createImage());
        plus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVPEditor.this.plus();
            }
        });
        final ToolItem minus = new ToolItem(buttonBar, 0);
        minus.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE").createImage());
        minus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MVPEditor.this.minus();
            }
        });
        minus.setEnabled(false);
        Composite tableParent = new Composite(composite, 0);
        GridData layoutData = new GridData(1808);
        layoutData.heightHint = 150;
        tableParent.setLayoutData((Object)layoutData);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableParent.setLayout((Layout)tableLayout);
        this.viewer = new TableViewer(tableParent, 2818);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        String[] rawLines = this.property.getValuesAsString();
        int i = 0;
        while (i < rawLines.length) {
            this.lines.add(new Line(rawLines[i]));
            ++i;
        }
        this.viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return MVPEditor.this.lines.toArray();
            }
        });
        TableViewerColumn column0 = new TableViewerColumn(this.viewer, 0);
        column0.getColumn().setText("Type");
        column0.getColumn().setResizable(true);
        column0.getColumn().setWidth(100);
        tableLayout.setColumnData((Widget)column0.getColumn(), (ColumnLayoutData)new ColumnWeightData(20, 100));
        column0.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                try {
                    cell.setText(MVPEditor.this.property.getTypeAsString());
                    cell.setForeground(MVPEditor.this.greyColor);
                }
                catch (Exception exception) {
                    cell.setText("n/a");
                    cell.setForeground(MVPEditor.this.greyColor);
                }
            }
        });
        TableViewerColumn column1 = new TableViewerColumn(this.viewer, 0);
        column1.getColumn().setText("Value");
        column1.getColumn().setResizable(true);
        column1.getColumn().setWidth(200);
        tableLayout.setColumnData((Widget)column1.getColumn(), (ColumnLayoutData)new ColumnWeightData(80, 200));
        column1.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                Line line = (Line)cell.getElement();
                cell.setText(line.getValue());
            }
        });
        column1.setEditingSupport(new EditingSupport((ColumnViewer)this.viewer){

            protected void setValue(Object element, Object value) {
                Line line = (Line)element;
                line.setValue(String.valueOf(value));
                MVPEditor.this.viewer.setInput((Object)MVPEditor.this.property);
            }

            protected Object getValue(Object element) {
                Line line = (Line)element;
                String value = line.getValue();
                System.out.println("Value=" + value);
                return value;
            }

            protected CellEditor getCellEditor(Object element) {
                return new TextCellEditor((Composite)MVPEditor.this.viewer.getTable());
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection iss = (IStructuredSelection)selection;
                    if (iss.isEmpty()) {
                        minus.setEnabled(false);
                    } else {
                        minus.setEnabled(true);
                    }
                } else {
                    minus.setEnabled(false);
                }
            }
        });
        this.viewer.setInput((Object)this.property);
        return composite;
    }

    protected void minus() {
        Object element;
        IStructuredSelection iss;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && !(iss = (IStructuredSelection)selection).isEmpty() && (element = iss.getFirstElement()) instanceof Line) {
            Line line = (Line)element;
            this.lines.remove(line);
        }
        this.viewer.setInput((Object)this.property);
    }

    protected void plus() {
        Line newLine = new Line("");
        this.lines.add(newLine);
        this.viewer.setInput((Object)this.property);
    }

    public String[] getLines() {
        String[] result = new String[this.lines.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.lines.get(i).getValue();
            ++i;
        }
        return result;
    }

    protected void okPressed() {
        boolean active = this.viewer.isCellEditorActive();
        if (active) {
            this.viewer.setInput((Object)this.property);
        }
        super.okPressed();
    }

    private class Line {
        private String value;

        Line(String value) {
            this.value = value;
        }

        void setValue(String value) {
            this.value = value;
        }

        String getValue() {
            return this.value;
        }
    }
}

