/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyState
extends ItemState {
    private static Logger log = LoggerFactory.getLogger(PropertyState.class);
    private QPropertyDefinition definition;
    private final boolean multiValued;
    private PropertyData transientData;
    private PropertyData data;

    protected PropertyState(PropertyEntry entry, ItemStateFactory isf, QPropertyDefinition definition, ItemDefinitionProvider definitionProvider, QValue[] values, int propertyType) throws ConstraintViolationException, RepositoryException {
        super(4, entry, isf, definitionProvider);
        this.multiValued = definition.isMultiple();
        this.definition = definition;
        this.setValues(values, propertyType);
    }

    protected PropertyState(PropertyEntry entry, PropertyInfo pInfo, ItemStateFactory isf, ItemDefinitionProvider definitionProvider) {
        super(entry, isf, definitionProvider);
        this.multiValued = pInfo.isMultiValued();
        this.data = new PropertyData(pInfo);
        this.transientData = null;
    }

    @Override
    public boolean isNode() {
        return false;
    }

    @Override
    public ItemId getId() throws RepositoryException {
        return ((PropertyEntry)this.getHierarchyEntry()).getId();
    }

    @Override
    public ItemId getWorkspaceId() throws RepositoryException {
        return ((PropertyEntry)this.getHierarchyEntry()).getWorkspaceId();
    }

    @Override
    public ItemState.MergeResult merge(ItemState another, boolean keepChanges) {
        boolean modified = false;
        if (another != null && another != this) {
            if (another.isNode()) {
                throw new IllegalArgumentException("Attempt to merge property state with node state.");
            }
            PropertyDiffer result = new PropertyDiffer(this.data, ((PropertyState)another).data);
            this.data = ((PropertyState)another).data;
            if (keepChanges || this.transientData == null) {
                return result;
            }
            result.dispose();
            this.transientData.discardValues();
            this.transientData = null;
            modified = true;
        }
        return new ItemState.SimpleMergeResult(modified);
    }

    @Override
    public boolean revert() {
        if (this.getStatus() == 4) {
            throw new IllegalStateException("Cannot call revert on a NEW property state.");
        }
        if (this.transientData == null) {
            return false;
        }
        this.transientData.discardValues();
        this.transientData = null;
        return true;
    }

    public int getType() {
        return this.transientData == null ? this.data.type : this.transientData.type;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public QPropertyDefinition getDefinition() throws RepositoryException {
        if (this.definition == null) {
            this.definition = this.definitionProvider.getQPropertyDefinition(this.getParent().getNodeTypeNames(), this.getName(), this.getType(), this.multiValued, ((PropertyEntry)this.getHierarchyEntry()).getWorkspaceId());
        }
        return this.definition;
    }

    public QValue[] getValues() {
        return this.transientData == null ? this.data.values : this.transientData.values;
    }

    public QValue getValue() throws ValueFormatException {
        if (this.isMultiValued()) {
            throw new ValueFormatException("'getValue' may not be called on a multi-valued state.");
        }
        QValue[] values = this.getValues();
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    void setValues(QValue[] values, int type) throws RepositoryException {
        if (this.getStatus() == 4) {
            if (this.data == null) {
                this.data = new PropertyData(type, values, this.getDefinition());
            } else {
                this.data.setValues(type, values, this.getDefinition());
            }
        } else {
            if (this.transientData == null) {
                this.transientData = new PropertyData(type, values, this.getDefinition());
            } else {
                this.transientData.setValues(type, values, this.getDefinition());
            }
            this.markModified();
        }
    }

    private static void validate(QValue[] values, int propertyType, QPropertyDefinition definition) throws ConstraintViolationException, RepositoryException {
        if (propertyType == 0) {
            throw new RepositoryException("'Undefined' is not a valid property type for existing values.");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || propertyType == values[i].getType()) continue;
            throw new ConstraintViolationException("Inconsistent value types: Required type = " + PropertyType.nameFromValue(propertyType) + "; Found value with type = " + PropertyType.nameFromValue(values[i].getType()));
        }
        if (definition.getRequiredType() != 0 && definition.getRequiredType() != propertyType) {
            throw new ConstraintViolationException("RequiredType constraint is not satisfied");
        }
        ValueConstraint.checkValueConstraints(definition, values);
    }

    private static boolean diff(PropertyData p1, PropertyData p2) {
        QValue[] vs2;
        if (p1.type != p2.type) {
            return true;
        }
        QValue[] vs1 = p1.values;
        if (vs1.length != (vs2 = p2.values).length) {
            return true;
        }
        for (int i = 0; i < vs1.length; ++i) {
            boolean eq;
            boolean bl = vs1[i] == null ? vs2[i] == null : (eq = vs1[i].equals(vs2[i]));
            if (eq) continue;
            return true;
        }
        return false;
    }

    private static class PropertyDiffer
    implements ItemState.MergeResult {
        private final PropertyData oldData;
        private final PropertyData newData;

        PropertyDiffer(PropertyData oldData, PropertyData newData) {
            this.oldData = oldData;
            this.newData = newData;
        }

        @Override
        public boolean modified() {
            if (this.oldData.discarded || this.newData.discarded) {
                String msg = " Diff cannot be calculated: " + (this.oldData.discarded ? "Old property data" : "New property data") + " have already been discarded.";
                log.debug(msg);
                return true;
            }
            return PropertyState.diff(this.oldData, this.newData);
        }

        @Override
        public void dispose() {
            this.oldData.discardValues();
        }
    }

    private static class PropertyData {
        private int type;
        private QValue[] values;
        private boolean discarded;

        private PropertyData(PropertyInfo pInfo) {
            this.type = pInfo.getType();
            this.values = pInfo.getValues();
        }

        private PropertyData(int type, QValue[] values, QPropertyDefinition definition) throws ConstraintViolationException, RepositoryException {
            this.setValues(type, values, definition);
        }

        private void setValues(int type, QValue[] values, QPropertyDefinition definition) throws ConstraintViolationException, RepositoryException {
            PropertyState.validate(values, type, definition);
            this.type = type;
            this.values = values == null ? QValue.EMPTY_ARRAY : values;
        }

        private void discardValues() {
            if (!this.discarded && this.values != null) {
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i] == null) continue;
                    this.values[i].discard();
                }
                this.discarded = true;
            }
        }
    }
}

