/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.oak.server.internal;

import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.oak.Oak;
import org.apache.sling.jcr.oak.server.internal.TcclWrappingJackrabbitSession;

public class TcclWrappingJackrabbitRepository
implements JackrabbitRepository {
    private final JackrabbitRepository wrapped;

    public TcclWrappingJackrabbitRepository(JackrabbitRepository wrapped) {
        this.wrapped = wrapped;
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(credentials, workspaceName, null);
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.login(credentials, null, null);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, workspaceName, null);
    }

    public Session login() throws LoginException, RepositoryException {
        return this.login(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session login(Credentials credentials, String workspaceName, Map<String, Object> attributes) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        Thread thread = Thread.currentThread();
        ClassLoader oldClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(Oak.class.getClassLoader());
        try {
            Session session = this.wrapped.login(credentials, workspaceName, attributes);
            TcclWrappingJackrabbitSession tcclWrappingJackrabbitSession = new TcclWrappingJackrabbitSession((JackrabbitSession)session);
            return tcclWrappingJackrabbitSession;
        }
        finally {
            thread.setContextClassLoader(oldClassLoader);
        }
    }

    public String[] getDescriptorKeys() {
        return this.wrapped.getDescriptorKeys();
    }

    public boolean isStandardDescriptor(String key) {
        return this.wrapped.isStandardDescriptor(key);
    }

    public boolean isSingleValueDescriptor(String key) {
        return this.wrapped.isSingleValueDescriptor(key);
    }

    public Value getDescriptorValue(String key) {
        return this.wrapped.getDescriptorValue(key);
    }

    public Value[] getDescriptorValues(String key) {
        return this.wrapped.getDescriptorValues(key);
    }

    public String getDescriptor(String key) {
        return this.wrapped.getDescriptor(key);
    }

    public void shutdown() {
        this.wrapped.shutdown();
    }
}

