/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi;

import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class DictionaryCollector<K, V>
implements Collector<Map.Entry<K, V>, Hashtable<K, V>, Dictionary<K, V>> {
    private final Function<? super Map.Entry<K, V>, ? extends K> keyMapper;
    private final Function<? super Map.Entry<K, V>, ? extends V> valueMapper;

    public DictionaryCollector(Function<? super Map.Entry<K, V>, ? extends K> keyMapper, Function<? super Map.Entry<K, V>, ? extends V> valueMapper) {
        this.keyMapper = keyMapper;
        this.valueMapper = valueMapper;
    }

    @Override
    public Supplier<Hashtable<K, V>> supplier() {
        return Hashtable::new;
    }

    @Override
    public BiConsumer<Hashtable<K, V>, Map.Entry<K, V>> accumulator() {
        return (hashTable, entry) -> {
            if (this.valueMapper.apply((Map.Entry<K, V>)entry) != null) {
                hashTable.put(this.keyMapper.apply((Map.Entry<K, V>)entry), this.valueMapper.apply((Map.Entry<K, V>)entry));
            }
        };
    }

    @Override
    public BinaryOperator<Hashtable<K, V>> combiner() {
        return (dictionary1, dictionary2) -> {
            dictionary1.putAll(dictionary2);
            return dictionary1;
        };
    }

    @Override
    public Function<Hashtable<K, V>, Dictionary<K, V>> finisher() {
        return table -> table;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Collections.singleton(Collector.Characteristics.UNORDERED);
    }
}

