/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.state;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.storm.shade.com.google.common.collect.Iterators;
import org.apache.storm.shade.com.google.common.collect.PeekingIterator;

public abstract class BaseStateIterator<K, V, KENCODEDT, VENCODEDT>
implements Iterator<Map.Entry<K, V>> {
    private final PeekingIterator<Map.Entry<KENCODEDT, VENCODEDT>> pendingPrepareIterator;
    private final PeekingIterator<Map.Entry<KENCODEDT, VENCODEDT>> pendingCommitIterator;
    private final Set<KENCODEDT> providedKeys;
    private boolean firstLoad = true;
    private PeekingIterator<Map.Entry<KENCODEDT, VENCODEDT>> pendingIterator;
    private PeekingIterator<Map.Entry<KENCODEDT, VENCODEDT>> cachedResultIterator;

    public BaseStateIterator(Iterator<Map.Entry<KENCODEDT, VENCODEDT>> pendingPrepareIterator, Iterator<Map.Entry<KENCODEDT, VENCODEDT>> pendingCommitIterator, Set<KENCODEDT> initialProvidedKeys) {
        this.pendingPrepareIterator = Iterators.peekingIterator(pendingPrepareIterator);
        this.pendingCommitIterator = Iterators.peekingIterator(pendingCommitIterator);
        this.providedKeys = initialProvidedKeys;
    }

    @Override
    public boolean hasNext() {
        if (this.seekToAvailableEntry(this.pendingPrepareIterator)) {
            this.pendingIterator = this.pendingPrepareIterator;
            return true;
        }
        if (this.seekToAvailableEntry(this.pendingCommitIterator)) {
            this.pendingIterator = this.pendingCommitIterator;
            return true;
        }
        if (this.firstLoad) {
            this.fillCachedResultIterator();
            this.firstLoad = false;
        }
        while (true) {
            if (this.seekToAvailableEntry(this.cachedResultIterator)) {
                this.pendingIterator = this.cachedResultIterator;
                return true;
            }
            if (this.isEndOfDataFromStorage()) break;
            this.fillCachedResultIterator();
        }
        this.pendingIterator = null;
        return false;
    }

    private void fillCachedResultIterator() {
        Iterator<Map.Entry<KENCODEDT, VENCODEDT>> iterator = this.loadChunkFromStateStorage();
        this.cachedResultIterator = iterator != null ? Iterators.peekingIterator(iterator) : null;
    }

    @Override
    public Map.Entry<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Map.Entry keyValue = (Map.Entry)this.pendingIterator.next();
        K key = this.decodeKey(keyValue.getKey());
        V value = this.decodeValue(keyValue.getValue());
        this.providedKeys.add(keyValue.getKey());
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    protected abstract Iterator<Map.Entry<KENCODEDT, VENCODEDT>> loadChunkFromStateStorage();

    protected abstract boolean isEndOfDataFromStorage();

    protected abstract K decodeKey(KENCODEDT var1);

    protected abstract V decodeValue(VENCODEDT var1);

    protected abstract boolean isTombstoneValue(VENCODEDT var1);

    private boolean seekToAvailableEntry(PeekingIterator<Map.Entry<KENCODEDT, VENCODEDT>> iterator) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.peek();
                if (!this.providedKeys.contains(entry.getKey())) {
                    if (this.isTombstoneValue(entry.getValue())) {
                        this.providedKeys.add(entry.getKey());
                    } else {
                        return true;
                    }
                }
                iterator.next();
            }
        }
        return false;
    }
}

