/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apache.streampark.common.conf.ConfigConst$;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.RedisEndpoint;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.util.Random$;

public final class RedisClient$
implements Logger {
    public static RedisClient$ MODULE$;
    private transient ConcurrentHashMap<RedisEndpoint, JedisPool> pools;
    private transient ConcurrentHashMap<RedisEndpoint, JedisCluster> clusters;
    private JedisPoolConfig poolConfig;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    static {
        new RedisClient$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private ConcurrentHashMap<RedisEndpoint, JedisPool> pools$lzycompute() {
        RedisClient$ redisClient$ = this;
        synchronized (redisClient$) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.pools = new ConcurrentHashMap();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.pools;
    }

    private ConcurrentHashMap<RedisEndpoint, JedisPool> pools() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.pools$lzycompute() : this.pools;
    }

    private ConcurrentHashMap<RedisEndpoint, JedisCluster> clusters$lzycompute() {
        RedisClient$ redisClient$ = this;
        synchronized (redisClient$) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.clusters = new ConcurrentHashMap();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.clusters;
    }

    private ConcurrentHashMap<RedisEndpoint, JedisCluster> clusters() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.clusters$lzycompute() : this.clusters;
    }

    public Jedis connect(RedisEndpoint[] endpoints) {
        Jedis jedis;
        while (true) {
            Predef$.MODULE$.require(endpoints.length > 0, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] The RedisEndpoint array is empty!!!");
            int index = RichInt$.MODULE$.abs$extension(Predef$.MODULE$.intWrapper(Random$.MODULE$.nextInt())) % endpoints.length;
            try {
                jedis = this.connect(endpoints[index]);
            }
            catch (Exception e) {
                this.logger().error(e.getMessage());
                endpoints = (RedisEndpoint[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])endpoints)).drop(index);
                continue;
            }
            break;
        }
        return jedis;
    }

    public Jedis connect(RedisEndpoint re) {
        JedisPool pool = (JedisPool)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaConcurrentMap(this.pools()).getOrElseUpdate((Object)re, (Function0 & Serializable & scala.Serializable)() -> MODULE$.createJedisPool(re));
        int sleepTime = 4;
        Jedis conn = null;
        while (conn == null) {
            try {
                conn = pool.getResource();
            }
            catch (Throwable throwable) {
                JedisConnectionException jedisConnectionException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof JedisConnectionException && (jedisConnectionException = (JedisConnectionException)throwable2).getCause().toString().contains("ERR max number of clients reached")) {
                    if (sleepTime < 500) {
                        sleepTime *= 2;
                    }
                    Thread.sleep(sleepTime);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (throwable2 instanceof Exception) {
                    Exception exception = (Exception)throwable2;
                    throw exception;
                }
                throw throwable;
            }
        }
        return conn;
    }

    public JedisPool createJedisPool(RedisEndpoint endpoint) {
        String x$1 = ConfigConst$.MODULE$.DEFAULT_DATAMASK_STRING();
        String x$2 = endpoint.copy$default$1();
        int x$3 = endpoint.copy$default$2();
        int x$4 = endpoint.copy$default$4();
        int x$5 = endpoint.copy$default$5();
        RedisEndpoint endpointEn = endpoint.copy(x$2, x$3, x$1, x$4, x$5);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("[StreamPark] RedisClient: createJedisPool with ").append(endpointEn).append(" ").toString());
        return new JedisPool((GenericObjectPoolConfig)this.poolConfig(), endpoint.host(), endpoint.port(), endpoint.timeout(), endpoint.auth(), endpoint.db());
    }

    /*
     * WARNING - void declaration
     */
    private JedisPoolConfig poolConfig$lzycompute() {
        RedisClient$ redisClient$ = this;
        synchronized (redisClient$) {
            if (!this.bitmap$0) {
                void var2_2;
                JedisPoolConfig poolConfig = new JedisPoolConfig();
                poolConfig.setMaxTotal(1000);
                poolConfig.setMaxIdle(64);
                poolConfig.setTestOnBorrow(true);
                poolConfig.setTestOnReturn(false);
                poolConfig.setTestWhileIdle(false);
                poolConfig.setMinEvictableIdleTimeMillis(1800000L);
                poolConfig.setTimeBetweenEvictionRunsMillis(30000L);
                poolConfig.setNumTestsPerEvictionRun(-1);
                this.poolConfig = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.poolConfig;
    }

    private JedisPoolConfig poolConfig() {
        return !this.bitmap$0 ? this.poolConfig$lzycompute() : this.poolConfig;
    }

    /*
     * WARNING - void declaration
     */
    public JedisCluster connectCluster(Seq<RedisEndpoint> res) {
        void var3_3;
        Predef$.MODULE$.require(res.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] The RedisEndpoint array is empty!!!");
        RedisEndpoint head = (RedisEndpoint)res.head();
        JedisCluster cluster = (JedisCluster)JavaConversions$.MODULE$.deprecated$u0020mapAsScalaConcurrentMap(this.clusters()).getOrElseUpdate((Object)head, (Function0 & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Set hostPorts = ((TraversableOnce)res.map((Function1 & Serializable & scala.Serializable)r -> new HostAndPort(r.host(), r.port()), Seq$.MODULE$.canBuildFrom())).toSet();
            return new JedisCluster(JavaConversions$.MODULE$.deprecated$u0020setAsJavaSet((Set)hostPorts), head.timeout(), 1000, 1, head.auth(), (GenericObjectPoolConfig)MODULE$.poolConfig());
        });
        return var3_3;
    }

    public void close() {
        JavaConversions$.MODULE$.deprecated$u0020mapAsScalaConcurrentMap(this.pools()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RedisClient$.$anonfun$close$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$close$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        JedisPool v = (JedisPool)tuple2._2();
        v.close();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private RedisClient$() {
        MODULE$ = this;
        Logger.$init$(this);
    }
}

