/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.client;

import java.io.IOException;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.test.web.client.AbstractRequestExpectationManager;
import org.springframework.test.web.client.RequestExpectation;

public class UnorderedRequestExpectationManager
extends AbstractRequestExpectationManager {
    private final AbstractRequestExpectationManager.RequestExpectationGroup remainingExpectations = new AbstractRequestExpectationManager.RequestExpectationGroup();

    @Override
    protected void afterExpectationsDeclared() {
        this.remainingExpectations.addAllExpectations(this.getExpectations());
    }

    @Override
    public RequestExpectation matchRequest(ClientHttpRequest request2) throws IOException {
        RequestExpectation expectation = this.remainingExpectations.findExpectation(request2);
        if (expectation == null) {
            throw this.createUnexpectedRequestError(request2);
        }
        this.remainingExpectations.update(expectation);
        return expectation;
    }

    @Override
    public void reset() {
        super.reset();
        this.remainingExpectations.reset();
    }
}

