/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.matrix.data;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.TernaryOperator;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.UtilFunctions;

public class LibMatrixTercell {
    private static final long PAR_NUMCELL_THRESHOLD = 8192L;

    private LibMatrixTercell() {
    }

    public static void tercellOp(MatrixBlock m1, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret, TernaryOperator op) {
        boolean s1 = m1.rlen == 1 && m1.clen == 1;
        boolean s2 = m2.rlen == 1 && m2.clen == 1;
        boolean s3 = m3.rlen == 1 && m3.clen == 1;
        double d1 = s1 ? m1.get(0, 0) : Double.NaN;
        double d2 = s2 ? m2.get(0, 0) : Double.NaN;
        double d3 = s3 ? m3.get(0, 0) : Double.NaN;
        ret.allocateBlock();
        if (op.getNumThreads() > 1 && ret.getLength() > 8192L) {
            ExecutorService pool = CommonThreadPool.get(op.getNumThreads());
            try {
                ArrayList<TercellTask> tasks = new ArrayList<TercellTask>();
                ArrayList<Integer> blklens = UtilFunctions.getBalancedBlockSizesDefault(ret.rlen, op.getNumThreads(), false);
                int lb = 0;
                for (int i = 0; i < blklens.size(); ++i) {
                    tasks.add(new TercellTask(m1, m2, m3, ret, op, s1, s2, s3, d1, d2, d3, lb, lb + blklens.get(i)));
                    lb += blklens.get(i).intValue();
                }
                List taskret = pool.invokeAll(tasks);
                ret.nonZeros = 0L;
                for (Future task : taskret) {
                    ret.nonZeros += ((Long)task.get()).longValue();
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new DMLRuntimeException(ex);
            }
            finally {
                pool.shutdown();
            }
        } else {
            long nnz = LibMatrixTercell.unsafeTernary(m1, m2, m3, ret, op, s1, s2, s3, d1, d2, d3, 0, ret.rlen);
            ret.setNonZeros(nnz);
        }
    }

    private static long unsafeTernary(MatrixBlock m1, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret, TernaryOperator op, boolean s1, boolean s2, boolean s3, double d1, double d2, double d3, int rl, int ru) {
        int n = ret.clen;
        long lnnz = 0L;
        for (int i = rl; i < ru; ++i) {
            for (int j = 0; j < n; ++j) {
                double in1 = s1 ? d1 : m1.get(i, j);
                double in2 = s2 ? d2 : m2.get(i, j);
                double in3 = s3 ? d3 : m3.get(i, j);
                double val = op.fn.execute(in1, in2, in3);
                lnnz += val != 0.0 ? 1L : 0L;
                ret.appendValuePlain(i, j, val);
            }
        }
        return lnnz;
    }

    private static class TercellTask
    implements Callable<Long> {
        private final MatrixBlock _m1;
        private final MatrixBlock _m2;
        private final MatrixBlock _m3;
        private final boolean _s1;
        private final boolean _s2;
        private final boolean _s3;
        private final double _d1;
        private final double _d2;
        private final double _d3;
        private final MatrixBlock _ret;
        private final TernaryOperator _op;
        private final int _rl;
        private final int _ru;

        protected TercellTask(MatrixBlock m1, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret, TernaryOperator op, boolean s1, boolean s2, boolean s3, double d1, double d2, double d3, int rl, int ru) {
            this._m1 = m1;
            this._m2 = m2;
            this._m3 = m3;
            this._s1 = s1;
            this._s2 = s2;
            this._s3 = s3;
            this._d1 = d1;
            this._d2 = d2;
            this._d3 = d3;
            this._ret = ret;
            this._op = op;
            this._rl = rl;
            this._ru = ru;
        }

        @Override
        public Long call() {
            return LibMatrixTercell.unsafeTernary(this._m1, this._m2, this._m3, this._ret, this._op, this._s1, this._s2, this._s3, this._d1, this._d2, this._d3, this._rl, this._ru);
        }
    }
}

