/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.iterators;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.util.UtilFunctions;

public abstract class RowIterator<T>
implements Iterator<T[]> {
    protected static final Log LOG = LogFactory.getLog((String)RowIterator.class.getName());
    protected final FrameBlock _fb;
    protected final int[] _cols;
    protected final T[] _curRow;
    protected final int _maxPos;
    protected int _curPos = -1;

    protected RowIterator(FrameBlock fb, int rl, int ru) {
        this(fb, rl, ru, UtilFunctions.getSeqArray(1, fb.getNumColumns(), 1));
    }

    protected RowIterator(FrameBlock fb, int rl, int ru, int[] cols) {
        if (rl < 0 || ru > fb.getNumRows() || rl > ru) {
            throw new DMLRuntimeException("Invalid range of iterator: " + rl + "->" + ru);
        }
        this._fb = fb;
        this._curRow = this.createRow(cols.length);
        this._cols = cols;
        this._maxPos = ru;
        this._curPos = rl;
    }

    @Override
    public boolean hasNext() {
        return this._curPos < this._maxPos;
    }

    @Override
    public void remove() {
        throw new DMLRuntimeException("RowIterator.remove() is unsupported!");
    }

    protected abstract T[] createRow(int var1);
}

