/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import io.smallrye.openapi.api.models.PathItemImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.ModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.OperationIO;
import io.smallrye.openapi.runtime.io.ReferenceIO;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import io.smallrye.openapi.runtime.io.parameters.ParameterIO;
import io.smallrye.openapi.runtime.io.servers.ServerIO;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.Operation;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.Reference;
import org.jboss.jandex.AnnotationInstance;

public class PathItemIO<V, A extends V, O extends V, AB, OB>
extends ModelIO<PathItem, V, A, O, AB, OB>
implements ReferenceIO<V, A, O, AB, OB> {
    private static final String PROP_DESCRIPTION = "description";
    private static final String PROP_PARAMETERS = "parameters";
    private static final String PROP_SERVERS = "servers";
    private static final String PROP_SUMMARY = "summary";
    private static final Set<String> OPERATION_PROPS = Arrays.asList(PathItem.HttpMethod.values()).stream().map(Enum::toString).map(String::toLowerCase).collect(Collectors.toSet());
    private final ServerIO<V, A, O, AB, OB> serverIO;
    protected final OperationIO<V, A, O, AB, OB> operationIO;
    private final ParameterIO<V, A, O, AB, OB> parameterIO;
    protected final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public PathItemIO(IOContext<V, A, O, AB, OB> context, OperationIO<V, A, O, AB, OB> operationIO, ContentIO<V, A, O, AB, OB> contentIO, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, null, Names.create(PathItem.class));
        this.serverIO = new ServerIO<V, A, O, AB, OB>(context, extensionIO);
        this.operationIO = operationIO;
        this.parameterIO = new ParameterIO<V, A, O, AB, OB>(context, contentIO, extensionIO);
        this.extensionIO = extensionIO;
    }

    @Override
    public PathItem read(AnnotationInstance annotation) {
        throw new UnsupportedOperationException("@PathItem annotation does not exist");
    }

    public PathItem read(AnnotationInstance[] annotations) {
        PathItemImpl pathItem = new PathItemImpl();
        Arrays.stream(annotations).filter(annotation -> Objects.nonNull(this.value((AnnotationInstance)annotation, "method"))).forEach(annotation -> {
            String method = (String)this.value((AnnotationInstance)annotation, "method");
            Operation operation = this.operationIO.read((AnnotationInstance)annotation);
            operation.setExtensions(this.extensionIO.readExtensible((AnnotationInstance)annotation));
            pathItem.setOperation(PathItem.HttpMethod.valueOf((String)method.toUpperCase(Locale.ROOT)), operation);
        });
        return pathItem;
    }

    @Override
    public PathItem readObject(O node) {
        IoLogging.logger.singleJsonNode("PathItem");
        PathItemImpl pathItem = new PathItemImpl();
        pathItem.setRef(this.readReference(node));
        pathItem.setSummary(this.jsonIO().getString(node, PROP_SUMMARY));
        pathItem.setDescription(this.jsonIO().getString(node, PROP_DESCRIPTION));
        this.jsonIO().properties(node).stream().filter(entry -> OPERATION_PROPS.contains(entry.getKey())).forEach(entry -> {
            PathItem.HttpMethod method = PathItem.HttpMethod.valueOf((String)((String)entry.getKey()).toUpperCase(Locale.ROOT));
            Operation operation = (Operation)this.operationIO.readValue(entry.getValue());
            pathItem.setOperation(method, operation);
        });
        pathItem.setParameters(this.parameterIO.readList(this.jsonIO().getValue(node, PROP_PARAMETERS)));
        pathItem.setServers(this.serverIO.readList(this.jsonIO().getValue(node, PROP_SERVERS)));
        pathItem.setExtensions(this.extensionIO.readObjectMap(node));
        return pathItem;
    }

    @Override
    public Optional<O> write(PathItem model) {
        return this.optionalJsonObject(model).map(node -> this.write(model, node)).map(this.jsonIO()::buildObject);
    }

    private OB write(PathItem model, OB node) {
        this.setReference(node, (Reference<?>)model);
        this.setIfPresent(node, PROP_SUMMARY, this.jsonIO().toJson(model.getSummary()));
        this.setIfPresent(node, PROP_DESCRIPTION, this.jsonIO().toJson(model.getDescription()));
        model.getOperations().forEach((method, operation) -> this.setIfPresent(node, method.name().toLowerCase(), this.operationIO.write((Operation)operation)));
        this.setIfPresent(node, PROP_PARAMETERS, this.parameterIO.write(model.getParameters()));
        this.setIfPresent(node, PROP_SERVERS, this.serverIO.write(model.getServers()));
        this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
        return node;
    }
}

