/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.torque.adapter.AbstractAdapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.sql.Query;

public class DerbyAdapter
extends AbstractAdapter {
    private static final long serialVersionUID = 6265962681516206415L;

    protected DerbyAdapter() {
    }

    @Override
    public String toUpperCase(String str) {
        return "UPPER(" + str + ")";
    }

    @Override
    public String ignoreCase(String str) {
        return this.toUpperCase(str);
    }

    @Override
    public IDMethod getIDMethodType() {
        return IDMethod.AUTO_INCREMENT;
    }

    @Override
    public String getIDMethodSQL(Object obj) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    @Override
    public void lockTable(Connection con, String table) throws SQLException {
        try (Statement statement = con.createStatement();){
            StringBuilder stmt = new StringBuilder();
            stmt.append("LOCK TABLE ").append(table).append(" IN EXCLUSIVE MODE");
            statement.executeUpdate(stmt.toString());
        }
    }

    @Override
    public void unlockTable(Connection con, String table) throws SQLException {
    }

    @Override
    public boolean escapeText() {
        return false;
    }

    @Override
    public boolean useEscapeClauseForLike() {
        return true;
    }

    @Override
    public boolean useGetGeneratedKeys() {
        return true;
    }

    @Override
    public void generateLimits(Query query, long offset, int limit) {
        StringBuilder postLimit = new StringBuilder();
        if (offset > 0L) {
            postLimit.append(" OFFSET ").append(offset).append(" ROWS");
        }
        if (limit >= 0) {
            postLimit.append(" FETCH NEXT ").append(limit).append(" ROWS ONLY");
        }
        query.setPostLimit(postLimit.toString());
        query.setLimit(null);
        query.setOffset(null);
    }
}

