/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.services.schedule.JobQueue;
import org.apache.turbine.services.schedule.ScheduleService;
import org.apache.turbine.services.schedule.WorkerThread;
import org.apache.turbine.util.TurbineException;

public abstract class AbstractSchedulerService
extends TurbineBaseService
implements ScheduleService {
    protected static final Logger log = LogManager.getLogger((String)"scheduler");
    protected JobQueue<JobEntry> scheduleQueue = null;
    private AtomicBoolean enabled = new AtomicBoolean(false);
    protected Thread houseKeepingThread;
    protected ExecutorService threadPool;

    @Override
    public void init() throws InitializationException {
        try {
            this.setEnabled(this.getConfiguration().getBoolean("enabled", true));
            this.scheduleQueue = new JobQueue();
            this.threadPool = Executors.newCachedThreadPool((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("Turbine-ScheduledJob-").daemon(true).build());
            List<? extends JobEntry> jobs = this.loadJobs();
            this.scheduleQueue.batchLoad(jobs);
            this.restart();
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("Could not initialize the scheduler service", e);
        }
    }

    protected abstract List<? extends JobEntry> loadJobs() throws TurbineException;

    @Override
    public void shutdown() {
        if (this.getThread() != null) {
            this.getThread().interrupt();
        }
        this.threadPool.shutdownNow();
    }

    @Override
    public abstract JobEntry newJob(int var1, int var2, int var3, int var4, int var5, String var6) throws TurbineException;

    @Override
    public abstract JobEntry getJob(int var1) throws TurbineException;

    @Override
    public void addJob(JobEntry je) throws TurbineException {
        this.updateJob(je);
    }

    @Override
    public abstract void removeJob(JobEntry var1) throws TurbineException;

    @Override
    public abstract void updateJob(JobEntry var1) throws TurbineException;

    public List<JobEntry> listJobs() {
        return this.scheduleQueue.list();
    }

    protected void setEnabled(boolean enabled) {
        this.enabled.set(enabled);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public synchronized void startScheduler() {
        this.setEnabled(true);
        this.restart();
    }

    @Override
    public synchronized void stopScheduler() {
        log.info("Stopping job scheduler");
        Thread thread = this.getThread();
        if (thread != null) {
            thread.interrupt();
        }
        this.setEnabled(false);
    }

    public synchronized Thread getThread() {
        return this.houseKeepingThread;
    }

    protected synchronized void clearThread() {
        this.houseKeepingThread = null;
    }

    public synchronized void restart() {
        if (this.enabled.get()) {
            log.info("Starting job scheduler");
            if (this.houseKeepingThread == null) {
                this.houseKeepingThread = new Thread(this::houseKeeping, "SchedulerService");
                this.houseKeepingThread.setDaemon(true);
                this.houseKeepingThread.start();
            } else {
                this.notify();
            }
        }
    }

    protected synchronized JobEntry nextJob() throws TurbineException {
        try {
            while (!Thread.interrupted()) {
                JobEntry je = this.scheduleQueue.getFirst();
                if (je == null) {
                    this.wait();
                    continue;
                }
                long now = System.currentTimeMillis();
                long when = je.getNextRuntime();
                if (when > now) {
                    this.wait(when - now);
                    continue;
                }
                this.scheduleQueue.updateQueue(je);
                return je;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    private void houseKeeping() {
        String taskName = null;
        try {
            JobEntry je;
            while (this.enabled.get() && (je = this.nextJob()) != null) {
                taskName = je.getTask();
                this.threadPool.execute(new WorkerThread(je));
            }
        }
        catch (Exception e) {
            log.error("Error running a Scheduled Job: {}", taskName, (Object)e);
            this.setEnabled(false);
        }
        finally {
            this.clearThread();
        }
    }
}

