/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.servlet;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.servlet.ServletService;
import org.apache.turbine.util.ServletUtils;

public class TurbineServletService
extends TurbineBaseService
implements ServletService {
    private static final Logger log = LogManager.getLogger(TurbineServletService.class);
    private ServletContext servletContext = null;
    private ServletConfig servletConfig = null;

    @Override
    public void init() {
        this.servletConfig = Turbine.getTurbineServletConfig();
        try {
            this.servletContext = this.servletConfig.getServletContext();
            log.debug("Initializing with ServletConfig");
        }
        catch (Exception e) {
            log.error("Cannot initialize TurbineServletService.", (Throwable)e);
        }
        this.setInit(true);
    }

    @Override
    public URL getResource(String uri) {
        if (this.servletContext == null) {
            return null;
        }
        URL url = null;
        try {
            url = this.getServletContext().getResource(uri);
            if (url != null && url.toString().startsWith("classloader:")) {
                url = new URL("file:" + url.toString().substring(12));
            } else if (url == null) {
                url = new URL("file:" + this.getServletContext().getRealPath(uri));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    @Override
    public InputStream getResourceAsStream(String uri) {
        if (this.servletContext == null) {
            return null;
        }
        InputStream is = null;
        is = this.servletContext.getResourceAsStream(uri);
        return is;
    }

    @Override
    public String getRealPath(String uri) {
        if (this.getServletContext() == null || uri == null) {
            return null;
        }
        return this.getServletContext().getRealPath(uri);
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public String getServerScheme() {
        return Turbine.getServerScheme();
    }

    @Override
    public String getServerName() {
        return Turbine.getServerName();
    }

    @Override
    public String getServerPort() {
        return Turbine.getServerPort();
    }

    @Override
    public String getContextPath() {
        return Turbine.getContextPath();
    }

    public String expandRelative(String path) {
        return ServletUtils.expandRelative(this.getServletConfig(), path);
    }
}

