/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.caseditor.view.tree;

import java.util.ArrayList;
import java.util.Comparator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.caseditor.view.tree.ITreeNode;

public class ArrayFeatureTreeNode
implements ITreeNode {
    private ITreeNode parent;
    private Feature f;
    private String value;
    private ArrayList<ITreeNode> children;

    public ArrayFeatureTreeNode(ITreeNode parent, Feature f, String value) {
        this.parent = parent;
        this.f = f;
        this.value = value;
        this.children = new ArrayList();
    }

    @Override
    public void addChild(ITreeNode child) {
        this.children.add(child);
    }

    @Override
    public ITreeNode[] getChildren() {
        return this.children.toArray(new ITreeNode[0]);
    }

    @Override
    public String getName() {
        return this.f.getShortName() + ": " + this.value;
    }

    @Override
    public ITreeNode getParent() {
        return this.parent;
    }

    @Override
    public Type getType() {
        return this.f.getRange();
    }

    @Override
    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public Feature getFeature() {
        return this.f;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void sort(Comparator<ITreeNode> cp) {
    }

    public Object getAdapter(Class adapter) {
        if (ArrayFeatureTreeNode.class.equals((Object)adapter)) {
            return this;
        }
        if (Feature.class.equals((Object)adapter)) {
            return this.f;
        }
        return null;
    }
}

