/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import java.util.Objects;

public class AppInfo
implements Comparable<AppInfo> {
    private String appId;
    private long updateTime;
    private long registrationTime;
    private String version;
    private String gitCommitId;

    public AppInfo(String appId, long updateTime, long registrationTime, String version, String gitCommitId) {
        this.appId = appId;
        this.updateTime = updateTime;
        this.registrationTime = registrationTime;
        this.version = version;
        this.gitCommitId = gitCommitId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public long getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(long updateTime) {
        this.updateTime = updateTime;
    }

    public long getRegistrationTime() {
        return this.registrationTime;
    }

    public void setRegistrationTime(long registrationTime) {
        this.registrationTime = registrationTime;
    }

    public String getVersion() {
        return this.version;
    }

    public String getGitCommitId() {
        return this.gitCommitId;
    }

    @Override
    public int compareTo(AppInfo appInfo) {
        return Long.compare(this.registrationTime, appInfo.getRegistrationTime());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AppInfo)) {
            return false;
        }
        AppInfo appInfo = (AppInfo)o;
        return this.updateTime == appInfo.updateTime && this.registrationTime == appInfo.registrationTime && this.appId.equals(appInfo.appId);
    }

    public int hashCode() {
        return Objects.hash(this.appId, this.updateTime, this.registrationTime);
    }

    public static AppInfo createAppInfo(String appId, long updateTime) {
        return AppInfo.createAppInfo(appId, updateTime, "", "");
    }

    public static AppInfo createAppInfo(String appId, long updateTime, String version, String gitCommitId) {
        return new AppInfo(appId, updateTime, updateTime, version, gitCommitId);
    }
}

