/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.rpc;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.net.SocketAddress;
import javax.annotation.Nullable;

public class ClientContextServerInterceptor
implements ServerInterceptor {
    private static final ThreadLocal<String> IP_ADDRESS_THREAD_LOCAL = new ThreadLocal();

    @Nullable
    public static String getIpAddress() {
        return IP_ADDRESS_THREAD_LOCAL.get();
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        this.setRemoteIpAddress(call);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

            public void onHalfClose() {
                ClientContextServerInterceptor.this.setRemoteIpAddress(call);
                super.onHalfClose();
            }
        };
    }

    private <ReqT, RespT> void setRemoteIpAddress(ServerCall<ReqT, RespT> call) {
        String remoteIpAddress = ((SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR)).toString();
        IP_ADDRESS_THREAD_LOCAL.set(remoteIpAddress);
    }
}

