/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.pool.KryoCallback;
import com.esotericsoftware.kryo.pool.KryoPool;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.config.RssConf;

public class PoolWrapper
implements KryoPool {
    private KryoPool pool = this.newKryoPool();
    private final boolean registrationRequired;
    private final boolean referenceTracking;

    public PoolWrapper(RssConf conf) {
        this.registrationRequired = conf.getBoolean(RssBaseConf.RSS_KRYO_REGISTRATION_REQUIRED);
        this.referenceTracking = conf.getBoolean(RssBaseConf.RSS_KRYO_REFERENCE_TRACKING);
    }

    private KryoPool newKryoPool() {
        return new KryoPool.Builder(() -> this.newKryo()).softReferences().build();
    }

    public Kryo newKryo() {
        Kryo kryo = new Kryo();
        kryo.setRegistrationRequired(this.registrationRequired);
        kryo.setReferences(this.referenceTracking);
        return kryo;
    }

    public Kryo borrow() {
        return this.pool.borrow();
    }

    public void release(Kryo kryo) {
        this.pool.release(kryo);
    }

    public <T> T run(KryoCallback<T> callback) {
        return (T)this.pool.run(callback);
    }

    public void reset() {
        this.pool = this.newKryoPool();
    }
}

