/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.serializer.writable;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.WritableUtils;
import org.apache.uniffle.common.serializer.SerOutputStream;
import org.apache.uniffle.common.serializer.SerializationStream;
import org.apache.uniffle.common.serializer.writable.WritableSerializerInstance;

public class RawWritableSerializationStream<K, V>
extends SerializationStream {
    private DataOutputStream dataOut;
    private SerOutputStream output;
    private long totalBytesWritten = 0L;

    public RawWritableSerializationStream(WritableSerializerInstance instance, SerOutputStream output) {
        this.output = output;
    }

    @Override
    public void init() {
        this.dataOut = new DataOutputStream(this.output);
    }

    @Override
    public void writeRecord(Object key, Object value) throws IOException {
        DataOutputBuffer keyBuffer = (DataOutputBuffer)key;
        DataOutputBuffer valueBuffer = (DataOutputBuffer)value;
        int keyLength = keyBuffer.getLength();
        int valueLength = valueBuffer.getLength();
        int toWriteLength = WritableUtils.getVIntSize((long)keyLength) + WritableUtils.getVIntSize((long)valueLength) + keyBuffer.getLength() + valueBuffer.getLength();
        this.output.preAllocate(toWriteLength);
        WritableUtils.writeVInt((DataOutput)this.dataOut, (int)keyLength);
        WritableUtils.writeVInt((DataOutput)this.dataOut, (int)valueLength);
        keyBuffer.writeTo((OutputStream)this.dataOut);
        valueBuffer.writeTo((OutputStream)this.dataOut);
        this.totalBytesWritten += (long)toWriteLength;
    }

    @Override
    public void flush() throws IOException {
        this.dataOut.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.dataOut != null) {
            this.dataOut.close();
            this.dataOut = null;
        }
    }

    @Override
    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }
}

