/*
 * Decompiled with CFR 0.152.
 */
package fleet.fastutil.longs;

import fleet.fastutil.longs.LongIterator;
import fleet.fastutil.longs.MutableLongIterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u001e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\rJ\u0016\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lfleet/fastutil/longs/LongArrays;", "", "<init>", "()V", "EMPTY_ARRAY", "", "getEMPTY_ARRAY", "()[J", "DEFAULT_EMPTY_ARRAY", "getDEFAULT_EMPTY_ARRAY", "forceCapacity", "array", "length", "", "preserve", "ensureCapacity", "grow", "trim", "unwrap", "i", "Lfleet/fastutil/longs/MutableLongIterator;", "Lfleet/fastutil/longs/LongIterator;", "offset", "max", "fleet.fastutil"})
public final class LongArrays {
    @NotNull
    public static final LongArrays INSTANCE = new LongArrays();
    @NotNull
    private static final long[] EMPTY_ARRAY = new long[0];
    @NotNull
    private static final long[] DEFAULT_EMPTY_ARRAY = new long[0];

    private LongArrays() {
    }

    @NotNull
    public final long[] getEMPTY_ARRAY() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public final long[] getDEFAULT_EMPTY_ARRAY() {
        return DEFAULT_EMPTY_ARRAY;
    }

    @NotNull
    public final long[] forceCapacity(@NotNull long[] array, int length, int preserve) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        long[] t2 = new long[length];
        ArraysKt.copyInto((long[])array, (long[])t2, (int)0, (int)0, (int)preserve);
        return t2;
    }

    @NotNull
    public final long[] ensureCapacity(@NotNull long[] array, int length, int preserve) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return length > array.length ? this.forceCapacity(array, length, preserve) : array;
    }

    @NotNull
    public final long[] grow(@NotNull long[] array, int length) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return this.grow(array, length, array.length);
    }

    @NotNull
    public final long[] grow(@NotNull long[] array, int length, int preserve) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (length > array.length) {
            int newLength = Math.max(Math.min(array.length + (array.length >> 1), 0x7FFFFFF7), length);
            long[] t2 = new long[newLength];
            ArraysKt.copyInto((long[])array, (long[])t2, (int)0, (int)0, (int)preserve);
            return t2;
        }
        return array;
    }

    @NotNull
    public final long[] trim(@NotNull long[] array, int length) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (length >= array.length) {
            return array;
        }
        long[] t2 = length == 0 ? EMPTY_ARRAY : new long[length];
        ArraysKt.copyInto((long[])array, (long[])t2, (int)0, (int)0, (int)length);
        return t2;
    }

    @NotNull
    public final long[] unwrap(@NotNull MutableLongIterator i2) {
        Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
        return this.unwrap((LongIterator)i2, Integer.MAX_VALUE);
    }

    public final int unwrap(@NotNull LongIterator i2, @NotNull long[] array, int offset, int max) {
        Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int offset2 = offset;
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset2 < 0 || offset2 + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j = max;
        while (j-- != 0 && i2.hasNext()) {
            array[offset2++] = i2.next();
        }
        return max - j - 1;
    }

    public final int unwrap(@NotNull LongIterator i2, @NotNull long[] array) {
        Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        return this.unwrap(i2, array, 0, array.length);
    }

    @NotNull
    public final long[] unwrap(@NotNull LongIterator i2, int max) {
        Intrinsics.checkNotNullParameter((Object)i2, (String)"i");
        int max2 = max;
        if (max2 < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max2 + ") is negative");
        }
        long[] array = new long[16];
        int j = 0;
        while (max2-- != 0 && i2.hasNext()) {
            if (j == array.length) {
                array = this.grow(array, j + 1);
            }
            array[j++] = i2.next();
        }
        return this.trim(array, j);
    }
}

