/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.api.endpoint.CollectionBackupApi;
import org.apache.solr.client.api.model.CreateCollectionRequestBody;
import org.apache.solr.client.api.model.RestoreCollectionRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.BackupAPIBase;
import org.apache.solr.handler.admin.api.CreateCollection;
import org.apache.solr.handler.configsets.ConfigSetAPIBase;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class RestoreCollection
extends BackupAPIBase
implements CollectionBackupApi.Restore {
    private static final Set<String> CREATE_PARAM_ALLOWLIST = Set.of("collection.configName", "replicationFactor", "nrtReplicas", "tlogReplicas", "pullReplicas", "createNodeSet", "createNodeSet.shuffle");

    @Inject
    public RestoreCollection(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SubResponseAccumulatingJerseyResponse restoreCollection(String backupName, RestoreCollectionRequestBody requestBody) throws Exception {
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required request body");
        }
        if (requestBody.collection == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required parameter 'collection' missing");
        }
        if (backupName == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Required parameter 'backupName' missing");
        }
        String collectionName = requestBody.collection;
        SolrIdentifierValidator.validateCollectionName((String)collectionName);
        RestoreCollection.recordCollectionForLogAndTracing(collectionName, this.solrQueryRequest);
        if (this.coreContainer.getAliases().hasAlias(collectionName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collection '" + collectionName + "' is an existing alias, no action taken.");
        }
        requestBody.location = this.getAndValidateBackupLocation(requestBody.repository, requestBody.location);
        CreateCollectionRequestBody createRequestBody = requestBody.createCollectionParams;
        if (createRequestBody != null) {
            CreateCollection.populateDefaultsIfNecessary(this.coreContainer, createRequestBody);
            CreateCollection.validateRequestBody(createRequestBody);
            if (Boolean.FALSE.equals(createRequestBody.createReplicas)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Replica-creation cannot be disabled for collections created by a restore operation.");
            }
        }
        ZkNodeProps remoteMessage = this.createRemoteMessage(backupName, requestBody);
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(this.coreContainer, this.coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.RESTORE, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        if (requestBody.async != null) {
            response.requestId = requestBody.async;
            return response;
        }
        response.successfulSubResponsesByNodeName = remoteResponse.getResponse().get("success");
        response.failedSubResponsesByNodeName = remoteResponse.getResponse().get("failure");
        return response;
    }

    public ZkNodeProps createRemoteMessage(String backupName, RestoreCollectionRequestBody requestBody) {
        Map remoteMessage = Utils.reflectToMap((Object)requestBody);
        CreateCollectionRequestBody createReqBody = requestBody.createCollectionParams;
        if (createReqBody != null) {
            remoteMessage.remove("create-collection");
            CreateCollection.createRemoteMessage(createReqBody).getProperties().entrySet().stream().filter(e -> CREATE_PARAM_ALLOWLIST.contains(e.getKey()) || ((String)e.getKey()).startsWith("property.")).forEach(e -> remoteMessage.put((String)e.getKey(), e.getValue()));
        }
        remoteMessage.put("operation", CollectionParams.CollectionAction.RESTORE.toLower());
        remoteMessage.put("name", backupName);
        remoteMessage.put("trusted", ConfigSetAPIBase.isTrusted(this.solrQueryRequest.getUserPrincipal(), this.coreContainer.getAuthenticationPlugin()));
        return new ZkNodeProps(remoteMessage);
    }

    public static SolrJerseyResponse invokeFromV1Params(SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse, CoreContainer coreContainer) throws Exception {
        SolrParams params = solrQueryRequest.getParams();
        params.required().check(new String[]{"name", "collection"});
        String backupName = params.get("name");
        RestoreCollectionRequestBody requestBody = RestoreCollection.createRequestBodyFromV1Params(params);
        RestoreCollection restoreApi = new RestoreCollection(coreContainer, solrQueryRequest, solrQueryResponse);
        return restoreApi.restoreCollection(backupName, requestBody);
    }

    public static RestoreCollectionRequestBody createRequestBodyFromV1Params(SolrParams solrParams) {
        RestoreCollectionRequestBody restoreBody = new RestoreCollectionRequestBody();
        restoreBody.collection = solrParams.get("collection");
        restoreBody.location = solrParams.get("location");
        restoreBody.repository = solrParams.get("repository");
        restoreBody.backupId = solrParams.getInt("backupId");
        restoreBody.async = solrParams.get("async");
        ModifiableSolrParams createCollectionParams = new ModifiableSolrParams(solrParams);
        createCollectionParams.set("name", new String[]{solrParams.get("collection")});
        restoreBody.createCollectionParams = CreateCollection.createRequestBodyFromV1Params((SolrParams)createCollectionParams, false);
        return restoreBody;
    }
}

