/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.io.eval.Attributes;

public class Matrix
implements Iterable<List<Double>>,
Attributes {
    private double[][] data;
    private List<String> columnLabels;
    private List<String> rowLabels;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public Matrix(double[][] data) {
        this.data = data;
    }

    @Override
    public Map<?, ?> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public List<String> getColumnLabels() {
        return this.columnLabels;
    }

    public void setColumnLabels(List<String> columnLabels) {
        this.columnLabels = columnLabels;
    }

    public List<String> getRowLabels() {
        return this.rowLabels;
    }

    public void setRowLabels(List<String> rowLabels) {
        this.rowLabels = rowLabels;
    }

    public double[][] getData() {
        return this.data;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public int getColumnCount() {
        return this.data[0].length;
    }

    @Override
    public Iterator<List<Double>> iterator() {
        return new MatrixIterator(this.data);
    }

    private static class MatrixIterator
    implements Iterator<List<Double>> {
        private double[][] d;
        private int index;

        public MatrixIterator(double[][] data) {
            this.d = data;
        }

        @Override
        public List<Double> next() {
            double[] row = this.d[this.index++];
            ArrayList<Double> list = new ArrayList<Double>();
            for (double value : row) {
                list.add(value);
            }
            return list;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.d.length;
        }
    }
}

