﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/connect/model/ParticipantRole.h>
#include <aws/connect/model/RealTimeContactAnalysisAttachment.h>
#include <aws/connect/model/RealTimeContactAnalysisTimeData.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {

/**
 * <p>Segment containing list of attachments.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/RealTimeContactAnalysisSegmentAttachments">AWS
 * API Reference</a></p>
 */
class RealTimeContactAnalysisSegmentAttachments {
 public:
  AWS_CONNECT_API RealTimeContactAnalysisSegmentAttachments() = default;
  AWS_CONNECT_API RealTimeContactAnalysisSegmentAttachments(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API RealTimeContactAnalysisSegmentAttachments& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONNECT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The identifier of the segment.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  RealTimeContactAnalysisSegmentAttachments& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier of the participant.</p>
   */
  inline const Aws::String& GetParticipantId() const { return m_participantId; }
  inline bool ParticipantIdHasBeenSet() const { return m_participantIdHasBeenSet; }
  template <typename ParticipantIdT = Aws::String>
  void SetParticipantId(ParticipantIdT&& value) {
    m_participantIdHasBeenSet = true;
    m_participantId = std::forward<ParticipantIdT>(value);
  }
  template <typename ParticipantIdT = Aws::String>
  RealTimeContactAnalysisSegmentAttachments& WithParticipantId(ParticipantIdT&& value) {
    SetParticipantId(std::forward<ParticipantIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The role of the participant. For example, is it a customer, agent, or
   * system.</p>
   */
  inline ParticipantRole GetParticipantRole() const { return m_participantRole; }
  inline bool ParticipantRoleHasBeenSet() const { return m_participantRoleHasBeenSet; }
  inline void SetParticipantRole(ParticipantRole value) {
    m_participantRoleHasBeenSet = true;
    m_participantRole = value;
  }
  inline RealTimeContactAnalysisSegmentAttachments& WithParticipantRole(ParticipantRole value) {
    SetParticipantRole(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The display name of the participant. Can be redacted. </p>
   */
  inline const Aws::String& GetDisplayName() const { return m_displayName; }
  inline bool DisplayNameHasBeenSet() const { return m_displayNameHasBeenSet; }
  template <typename DisplayNameT = Aws::String>
  void SetDisplayName(DisplayNameT&& value) {
    m_displayNameHasBeenSet = true;
    m_displayName = std::forward<DisplayNameT>(value);
  }
  template <typename DisplayNameT = Aws::String>
  RealTimeContactAnalysisSegmentAttachments& WithDisplayName(DisplayNameT&& value) {
    SetDisplayName(std::forward<DisplayNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>List of objects describing an individual attachment.</p>
   */
  inline const Aws::Vector<RealTimeContactAnalysisAttachment>& GetAttachments() const { return m_attachments; }
  inline bool AttachmentsHasBeenSet() const { return m_attachmentsHasBeenSet; }
  template <typename AttachmentsT = Aws::Vector<RealTimeContactAnalysisAttachment>>
  void SetAttachments(AttachmentsT&& value) {
    m_attachmentsHasBeenSet = true;
    m_attachments = std::forward<AttachmentsT>(value);
  }
  template <typename AttachmentsT = Aws::Vector<RealTimeContactAnalysisAttachment>>
  RealTimeContactAnalysisSegmentAttachments& WithAttachments(AttachmentsT&& value) {
    SetAttachments(std::forward<AttachmentsT>(value));
    return *this;
  }
  template <typename AttachmentsT = RealTimeContactAnalysisAttachment>
  RealTimeContactAnalysisSegmentAttachments& AddAttachments(AttachmentsT&& value) {
    m_attachmentsHasBeenSet = true;
    m_attachments.emplace_back(std::forward<AttachmentsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Field describing the time of the event. It can have different representations
   * of time.</p>
   */
  inline const RealTimeContactAnalysisTimeData& GetTime() const { return m_time; }
  inline bool TimeHasBeenSet() const { return m_timeHasBeenSet; }
  template <typename TimeT = RealTimeContactAnalysisTimeData>
  void SetTime(TimeT&& value) {
    m_timeHasBeenSet = true;
    m_time = std::forward<TimeT>(value);
  }
  template <typename TimeT = RealTimeContactAnalysisTimeData>
  RealTimeContactAnalysisSegmentAttachments& WithTime(TimeT&& value) {
    SetTime(std::forward<TimeT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_id;

  Aws::String m_participantId;

  ParticipantRole m_participantRole{ParticipantRole::NOT_SET};

  Aws::String m_displayName;

  Aws::Vector<RealTimeContactAnalysisAttachment> m_attachments;

  RealTimeContactAnalysisTimeData m_time;
  bool m_idHasBeenSet = false;
  bool m_participantIdHasBeenSet = false;
  bool m_participantRoleHasBeenSet = false;
  bool m_displayNameHasBeenSet = false;
  bool m_attachmentsHasBeenSet = false;
  bool m_timeHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
