﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/migrationhuborchestrator/MigrationHubOrchestrator_EXPORTS.h>
#include <aws/migrationhuborchestrator/model/DataType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MigrationHubOrchestrator {
namespace Model {

/**
 * <p>The input parameters of a template.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/migrationhuborchestrator-2021-08-28/TemplateInput">AWS
 * API Reference</a></p>
 */
class TemplateInput {
 public:
  AWS_MIGRATIONHUBORCHESTRATOR_API TemplateInput() = default;
  AWS_MIGRATIONHUBORCHESTRATOR_API TemplateInput(Aws::Utils::Json::JsonView jsonValue);
  AWS_MIGRATIONHUBORCHESTRATOR_API TemplateInput& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MIGRATIONHUBORCHESTRATOR_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the template.</p>
   */
  inline const Aws::String& GetInputName() const { return m_inputName; }
  inline bool InputNameHasBeenSet() const { return m_inputNameHasBeenSet; }
  template <typename InputNameT = Aws::String>
  void SetInputName(InputNameT&& value) {
    m_inputNameHasBeenSet = true;
    m_inputName = std::forward<InputNameT>(value);
  }
  template <typename InputNameT = Aws::String>
  TemplateInput& WithInputName(InputNameT&& value) {
    SetInputName(std::forward<InputNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data type of the template input.</p>
   */
  inline DataType GetDataType() const { return m_dataType; }
  inline bool DataTypeHasBeenSet() const { return m_dataTypeHasBeenSet; }
  inline void SetDataType(DataType value) {
    m_dataTypeHasBeenSet = true;
    m_dataType = value;
  }
  inline TemplateInput& WithDataType(DataType value) {
    SetDataType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Determine if an input is required from the template.</p>
   */
  inline bool GetRequired() const { return m_required; }
  inline bool RequiredHasBeenSet() const { return m_requiredHasBeenSet; }
  inline void SetRequired(bool value) {
    m_requiredHasBeenSet = true;
    m_required = value;
  }
  inline TemplateInput& WithRequired(bool value) {
    SetRequired(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_inputName;

  DataType m_dataType{DataType::NOT_SET};

  bool m_required{false};
  bool m_inputNameHasBeenSet = false;
  bool m_dataTypeHasBeenSet = false;
  bool m_requiredHasBeenSet = false;
};

}  // namespace Model
}  // namespace MigrationHubOrchestrator
}  // namespace Aws
