﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/redshift/RedshiftRequest.h>
#include <aws/redshift/Redshift_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Redshift {
namespace Model {

/**
 */
class DescribeRedshiftIdcApplicationsRequest : public RedshiftRequest {
 public:
  AWS_REDSHIFT_API DescribeRedshiftIdcApplicationsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeRedshiftIdcApplications"; }

  AWS_REDSHIFT_API Aws::String SerializePayload() const override;

 protected:
  AWS_REDSHIFT_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
  ///@{
  /**
   * <p>The ARN for the Redshift application that integrates with IAM Identity
   * Center.</p>
   */
  inline const Aws::String& GetRedshiftIdcApplicationArn() const { return m_redshiftIdcApplicationArn; }
  inline bool RedshiftIdcApplicationArnHasBeenSet() const { return m_redshiftIdcApplicationArnHasBeenSet; }
  template <typename RedshiftIdcApplicationArnT = Aws::String>
  void SetRedshiftIdcApplicationArn(RedshiftIdcApplicationArnT&& value) {
    m_redshiftIdcApplicationArnHasBeenSet = true;
    m_redshiftIdcApplicationArn = std::forward<RedshiftIdcApplicationArnT>(value);
  }
  template <typename RedshiftIdcApplicationArnT = Aws::String>
  DescribeRedshiftIdcApplicationsRequest& WithRedshiftIdcApplicationArn(RedshiftIdcApplicationArnT&& value) {
    SetRedshiftIdcApplicationArn(std::forward<RedshiftIdcApplicationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The maximum number of response records to return in each call. If the number
   * of remaining response records exceeds the specified MaxRecords value, a value is
   * returned in a marker field of the response. You can retrieve the next set of
   * records by retrying the command with the returned marker value.</p>
   */
  inline int GetMaxRecords() const { return m_maxRecords; }
  inline bool MaxRecordsHasBeenSet() const { return m_maxRecordsHasBeenSet; }
  inline void SetMaxRecords(int value) {
    m_maxRecordsHasBeenSet = true;
    m_maxRecords = value;
  }
  inline DescribeRedshiftIdcApplicationsRequest& WithMaxRecords(int value) {
    SetMaxRecords(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A value that indicates the starting point for the next set of response
   * records in a subsequent request. If a value is returned in a response, you can
   * retrieve the next set of records by providing this returned marker value in the
   * Marker parameter and retrying the command. If the Marker field is empty, all
   * response records have been retrieved for the request. </p>
   */
  inline const Aws::String& GetMarker() const { return m_marker; }
  inline bool MarkerHasBeenSet() const { return m_markerHasBeenSet; }
  template <typename MarkerT = Aws::String>
  void SetMarker(MarkerT&& value) {
    m_markerHasBeenSet = true;
    m_marker = std::forward<MarkerT>(value);
  }
  template <typename MarkerT = Aws::String>
  DescribeRedshiftIdcApplicationsRequest& WithMarker(MarkerT&& value) {
    SetMarker(std::forward<MarkerT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_redshiftIdcApplicationArn;

  int m_maxRecords{0};

  Aws::String m_marker;
  bool m_redshiftIdcApplicationArnHasBeenSet = false;
  bool m_maxRecordsHasBeenSet = false;
  bool m_markerHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
